/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package function;

import collection.RingBuffer;
import java.util.function.Predicate;
import view.View;

/**
 *
 * @author mtomono
 */
public class ViewHolder<T> {
    View<T> view;
    RingBuffer<T> buffer;
    
    public static <T> ViewHolder<T> fore(int length) {
        return fore(new RingBuffer<>(length));
    }
    
    public static <T> ViewHolder<T> fore(RingBuffer buffer) {
        return new ViewHolder<>(View.fore(buffer, buffer.size()), buffer);
    }
    
    public static <T> ViewHolder<T> pre(int length) {
        return pre(new RingBuffer<>(length));
    }

    public static <T> ViewHolder<T> pre(RingBuffer buffer) {
        return new ViewHolder<>(View.pre(buffer, buffer.size()), buffer);
    }

    public ViewHolder(View<T> view, RingBuffer<T> buffer) {
        this.view = view;
        this.buffer = buffer;
    }
    
    public boolean t(int index, Predicate<T> t) {
        return view.t(index, t);
    }
    
    public T g(int index) {
        return view.g(index);
    }
    
    public View<T> peek() {
        return view;
    }
    
    public T push(T v) {
        return buffer.push(v);
    }
    
    public T pop(T v) {
        return buffer.pop(v);
    }
}
