/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package iterator;

import collection.MapIterable;
import context.IContext;
import static debug.Fixture.*;
import function.Holder;
import function.ViewHolder;
import static iterator.Iterators.*;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import static java.util.stream.Collectors.toList;
import static org.testng.Assert.*;
import org.testng.annotations.Test;
import parser.ParseAndStay;
import static grammar.Grammars.*;

/**
 *
 * @author mtpopeekmpopeeknpopeek
 */
public class MapIteratorTest {
    
    public MapIteratorTest() {
    }

    @Test
    public void replaceInsideOut() {
        List<Integer> tested = Arrays.<Integer>asList(1, 5, 4, 6, 3);
        List<Integer> expected = Arrays.<Integer>asList(1, 6, 10, 16, 19);
        Holder<Integer> h = new Holder<>(0);
        assertTrue(Iterators.test(new MapIterator<>(tested.iterator(), v->h.set(h.get() + v)), expected.iterator()));
    }
    
    @Test
    public void replaceInsert() {
        List<Integer> tested = Arrays.asList(1, 13, 17, 25, 36, 49);
        List<Integer> expected = Arrays.asList(1, 11, 13, 17, 25, 35, 36, 46, 49);
        ViewHolder<Integer> h = ViewHolder.pre(1);
        ListIterator<Integer> iter = tested.listIterator();
        List<Integer> result = toStream(new MapIterator<>(iter, 
                n-> {
                    int retval;
                    if (h.t(0, x->n-x<10))
                        retval = n;
                    else {
                        retval = h.g(0) + 10;
                        iter.previous();
                    }
                    h.push(retval);
                    return retval;
                }
            )).collect(toList());
        assertEquals(result, expected);
    }
    
    @Test
    public void replaceScoped() {
        List<String> tested = slist("t0 t1 t2 t3");
        List<List<Optional<String>>> expected = a(
                a(Optional.of("t0"), Optional.empty()),
                a(Optional.of("t1"), Optional.of("t0")),
                a(Optional.of("t2"), Optional.of("t1")),
                a(Optional.of("t3"), Optional.of("t2"))
        );
        ViewHolder<String> h = ViewHolder.pre(2);
        Iterable<List<Optional<String>>> iter = new MapIterable(()->
                new MapIterator<>(tested.iterator(), 
                    n-> {
                        h.push(n);
                        return h.peek();
                    }
                ));
        assertTrue(test(iter.iterator(), expected.iterator()));
     }
    
    @Test
    public void replaceIContext() {
        List<String> alist = slist("t0 t1 t0 t2 t0 t3 t0");
        PreIterator<String> iter = new PreIterator<>(alist.iterator(), 2);
        IContext<String> context = IContext.c(iter.pre(), 1);
        Iterator<String> tested = new UntilIterator<>(
                new SingleBufferedListIterator<>(iter), 
                n->ParseAndStay.matches(s(e("t0"), e("t2")), context));
        List<String> expected = slist("t0 t1 t0");
        List<String> result = Iterators.toStream(tested).collect(toList());
        System.out.println(result);
        assertEquals(result, expected);
    }
}
