/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package parser;

import parser.Parser;
import context.IContext;
import grammar.Grammar;

/**
 *
 * @author mtomono
 */
public class EasyParser<T> extends Parser<T> {
    public EasyParser(Grammar<T> grammar) {
        super(grammar);
        assert grammar.minLength() > 0 : "minimum length of grammar must be > 0";
    }
    
    @Override
    public void match(IContext<T> context) {
        while (context.hasNext()) {
            int current = context.save();
            if (!body.parseEntry(context)) {
                context.load(current);
                context.next();
            }
        }
    }
}
