/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import java.util.ListIterator;

/**
 *
 * @author mtomono
 */
public class RangeOverlapsPointIterator<T extends Comparable<T>> extends IfAnyRightWalker<Range<T>, T> {
    public RangeOverlapsPointIterator(ListIterator<Range<T>> iterL, ListIterator<T> iterR) {
        super(iterL, iterR);
    }
    
    @Override
    public boolean leftCatchesRight(Range<T> left, T right) {
        return left.hasUpperThan(right);
    }

    @Override
    public boolean doesRightStay(Range<T> left, T right) {
        return false; // left.isBelow(right) だけど、これは常にfalse
    }

    @Override
    public boolean matches(Range<T> left, T right) {
        return left.contains(right);
    }
}
