/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import collection.c;
import iterator.BufferedListIterator;
import static iterator.Iterators.toStream;
import iterator.RingBufferedListIterator;
import iterator.SingleBufferedListIterator;
import java.util.*;
import static java.util.stream.Collectors.toList;

/**
 *
 * @author mtomono
 * @param <T>
 */
public class ExtensiveSet<T extends Comparable<T>> {
    Order<T> order;
    List<T> body;
    
    public ExtensiveSet(Order<T> order, List<T> body) {
        this.body = body;
        this.order = order;
        assert isInOrder(body);
    }
    
    public ExtensiveSet(List<T> body) {
        this(Default.order, body);
    }
    
    public ExtensiveSet(T... body) {
        this(c.a2l(body));
    }
    
    final public boolean isInOrder(List<T> target) {
        AssertOrderListIterator<T> iter = new AssertOrderListIterator<>(target.iterator());
        while (iter.hasNext()) {
            iter.next();
        }
        return true;
    }
    
    public boolean contains(T point) {
        return body.contains(point);
    }
    
    public Walker<T, T> containsIterator(ListIterator<T> points) {
        return new PointContainsPointIterator<>(body.listIterator(), points);
    }
    
    public boolean contains(List<T> points) {
        return toStream(containsIterator(points.listIterator())).allMatch(n->n);
    }
    
    public Walker<T, T> overlapsIterator(ListIterator<T> points) {
        return new PointOverlapsPointIterator<>(body.listIterator(), points);
    }
    
    public boolean overlaps(List<T> points) {
        return toStream(overlapsIterator(points.listIterator())).anyMatch(n->n);
    }
    
    public Iterator<T> intersectIterator(ListIterator<T> points) {
        return new PointIntersectsPointIterator<>(body.listIterator(), points);
    }
    
    public List<T> intersect(List<T> points) {
        return toStream(intersectIterator(points.listIterator())).collect(toList());
    }
    
    public Iterator<T> maskIterator(ListIterator<T> points) {
        return new PointMasksPointIterator(body.listIterator(), points);
    }
    
    public List<T> mask(List<T> points) {
        return toStream(maskIterator(points.listIterator())).collect(toList());
    }
}
