/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import java.util.List;

/**
 *
 * @author mtomono
 */
public class Empty<T extends Comparable<T>> extends Range<T> {
    public Empty() {
        super();
    }
    
    @Override
    public Range<T> clone() {
        return this;
    }
    
    @Override
    public boolean equals(Object o) {
        return o instanceof Empty;
    }
    
    @Override
    public int hashCode() {
        int hash = 7;
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }
    
    @Override
    public boolean startsAt(T value) {
        return false;
    }
    
    @Override
    public boolean endsAt(T value) {
        return false;
    }
    
    @Override
    public boolean contains(T value) {
        return false;
    }
    
    @Override
    public boolean contains(List<T> another) {
        return false;
    }
    
    @Override
    public boolean contains(Range<T> another) {
        return another instanceof Empty;
    }
    
    @Override
    public boolean overlaps(List<T> another) {
        return false;
    }
    
    @Override
    public boolean overlaps(Range<T> another) {
        return false;
    }
    
    @Override
    public boolean hasLowerThan(T value) {
        return false;
    }
    
    @Override
    public boolean hasUpperThan(T value) {
        return false;
    }
        
    @Override
    public boolean startsUpperThan(Range<T> value) {
        return false;
    }
    
    @Override
    public boolean endsLowerThan(Range<T> value) {
        return false;
    }
    
    @Override
    public boolean isLowerThan(Range<T> another) {
        return true;
    }
    
    @Override
    public boolean isUpperThan(Range<T> another) {
        return true;
    }
    
    @Override
    public boolean isBelow(T value) {
        return true;
    }
    
    @Override
    public boolean isAbove(T value) {
        return true;
    }
    
    @Override
    public boolean isBelow(Range<T> another) {
        return true;
    }
    
    @Override
    public boolean isAbove(Range<T> another) {
        return true;
    }
    
    @Override
    public boolean adjoins(Range<T> another) {
        return false;
    }
    
    @Override
    public boolean adjoinsAtStartWith(Range<T> another) {
        return false;
    }
    
    @Override
    public boolean adjoinsAtEndWith(Range<T> another) {
        return false;
    }
    
    @Override
    public Range<T> intersect(Range<T> another) {
        return this;
    }
    
    @Override
    public Range<T> cover(T value) {
        return new Point<>(value);
    }
    
    @Override
    public Range<T> cover(Range<T> another) {
        return another;
    }
    
    @Override
    public Range<T> getLower(T value) {
        return this;
    }
    
    @Override
    public Range<T> getUpper(T value) {
        return this;
    }
    
    @Override
    public Range<T> getLowerRoomIn(Range<T> another) {
        return another;
    }
    
    @Override
    public Range<T> getUpperRoomIn(Range<T> another) {
        return another;
    }
    
    @Override
    public String toString() {
        return "EmptyFragment";
    }
}
