/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package grammar;

import collection.c;
import context.IContext;
import java.util.List;

/**
 *
 * @author mtomono
 */
public class SeqAction implements Action {
    List<Action> actions;
    
    public SeqAction(Action... actions) {
        this(c.a2l(actions));
    }
    
    public SeqAction(List<Action> actions) {
        this.actions = actions;
    }
    
    @Override
    public void init(IContext<?> context, Grammar origin) {
        actions.stream().forEach(a->a.init(context, origin));
    }

    @Override
    public void match(IContext<?> context, int start, int end, Grammar origin) {
        actions.stream().forEach(a->a.match(context, start, end, origin));
    }

    @Override
    public void fail(IContext<?> context, Grammar origin) {
        actions.stream().forEach(a->a.fail(context, origin));
    }
    
    @Override
    public String toString() {
        return actions.stream().map(a->a.toString()).reduce("", (a, b)->a+" "+b);
    }
}
