/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package function;

import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

/**
 *
 * @author mtomono
 */
public class Pipe {
    
    public static IntSupplier p(IntSupplier supplier, IntUnaryOperator map) {
        return ()->map.applyAsInt(supplier.getAsInt());
    }

    public static LongSupplier p(LongSupplier supplier, LongUnaryOperator map) {
        return ()->map.applyAsLong(supplier.getAsLong());
    }

    public static DoubleSupplier p(DoubleSupplier supplier, DoubleUnaryOperator map) {
        return ()->map.applyAsDouble(supplier.getAsDouble());
    }

    public static <T> Supplier<T> p(Supplier<T> supplier, UnaryOperator<T> map) {
        return ()->map.apply(supplier.get());
    }

    public static <T, R> Supplier<R> p(Supplier<T> supplier, Function<T, R> map) {
        return ()->map.apply(supplier.get());
    }

}
