/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package parser;

import context.IContext;
import grammar.Grammar;

/**
 * convenience methods which matches grammar to a context but keeps position
 * of context.
 * @author mtomono
 */
public class ParseAndStay {

    public static <T> boolean matches(Grammar<T> body, IContext<T> target) {
        int start = target.save();
        boolean retval = body.parseEntry(target);
        target.load(start);
        return retval;
    }
    
    public static <T> int length(Grammar<T> body, IContext<T> target) {
        int start = target.save();
        body.parseEntry(target);
        int retval = target.save() - start;
        target.load(start);
        return retval;
    }
}
