/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import java.util.*;
import debug.Format;
import static debug.Trace.*;
import iterator.Iterators;
import static iterator.Iterators.toStream;
import static java.util.stream.Collectors.toList;
import view.View;
import view.ViewList;

/**
 *
 * @author mtomono
 */
public class RangeSet<T extends Comparable<T>> {
    List<Range<T>> elements;
    
    public ListIterator<Range<T>> listIterator() {
        return elements.listIterator();
    }
    
    @Override
    public boolean equals(Object e) {
        if (!(e instanceof RangeSet))
            return false;
        return elements.equals(((RangeSet)e).elements);
    }

    public final boolean rangesAreInOrder(List<Range<T>> target) {
        return ViewList.inner(View.fore(target, 2)).stream().
                filter(v->v.get(0).isPresent() && v.get(1).isPresent()).
                allMatch(v->v.get(0).get().isLowerThan(v.get(1).get()));
    }
   
    public final boolean pointsAreInOrder(List<T> target) {
        return ViewList.inner(View.fore(target, 2)).stream().
                filter(v->v.get(0).isPresent() && v.get(1).isPresent()).
                allMatch(v->Default.order.lt(v.get(0).get(),v.get(1).get()));
    }
   
    public RangeSet() {
        this.elements = Collections.<Range<T>>emptyList();
    }
    
    public RangeSet(Range<T> range) {
        this.elements = Collections.<Range<T>>singletonList(range);
    }
    
    public RangeSet(List<Range<T>> elements) {
        assert rangesAreInOrder(elements);
        this.elements = elements;
    }
    
    public RangeSet(Order<T> order, T... range) {
        this(Between.<T>c(order, range));
    }
    
    public RangeSet(T... range) {
        this(Default.order, range);
    }
    
    public boolean isEmpty() {
        return elements.isEmpty();
    }
    
    public List<Range<T>> toFragments() {
        return elements;
    }
    
    public boolean contains(T point) {
        return containsPoints(Collections.singletonList(point));
    }
    
    public boolean contains(Range<T> range) {
        return contains(Collections.singletonList(range));
    }
    
    public Walker<Range<T>, T> containsPointsWalker(ListIterator<T> another) {
        return new RangeContainsPointIterator<>(this.listIterator(), another);
    }
    
    public boolean containsPoints(ListIterator<T> another) {
        return toStream(containsPointsWalker(another)).allMatch(n->n);
    }

    public boolean containsPoints(List<T> another) {
        assert pointsAreInOrder(another);
        return containsPoints(another.listIterator());
    }
    
    public Walker<Range<T>, Range<T>> containsRangesWalker(ListIterator<Range<T>> another) {
        return new RangeContainsRangeIterator<>(this.listIterator(), another);
    }
    
    public boolean contains(List<Range<T>> another) {
        assert rangesAreInOrder(another);
        return toStream(containsRangesWalker(another.listIterator())).allMatch(n->n);
    }
    
    public boolean contains(RangeSet<T> another) {
        return contains(another.elements);
    }
    
    public Walker<Range<T>, T> overlapsPointsWalker(ListIterator<T> another) {
        return new RangeOverlapsPointIterator<>(this.listIterator(), another);
    }
    
    public boolean overlapsPoints(ListIterator<T> points) {
        return toStream(overlapsPointsWalker(points)).anyMatch(n->n);
    }
    
    public boolean overlapsPoints(List<T> points) {
        assert pointsAreInOrder(points);
        return toStream(overlapsPointsWalker(points.listIterator())).anyMatch(n->n);
    }
    
    public Walker<Range<T>, Range<T>> overlapsRangesWalker(ListIterator<Range<T>> another) {
        return new RangeOverlapsRangeIterator<>(this.listIterator(), another);
    }
    
    public boolean overlaps(List<Range<T>> another) {
        assert rangesAreInOrder(another);
        return toStream(overlapsRangesWalker(another.listIterator())).anyMatch(n->n);
    }
    
    public boolean overlaps(RangeSet<T> another) {
        return overlaps(another.elements);
    }
    
    public Iterator<Range<T>> intersectIterator(ListIterator<Range<T>> another) {
        return new RangeIntersectsRangeIterator<>(this.listIterator(), another);
    }
    
    public List<Range<T>> intersect(List<Range<T>> another) {
        assert rangesAreInOrder(another);
        return toStream(intersectIterator(another.listIterator())).collect(toList());
    }
    
    public RangeSet<T> intersect(RangeSet<T> another) {
        return new RangeSet<>(intersect(another.elements));
    }
    
    public Iterator<Range<T>> negateIterator(Range<T> target) {
        return new NegateRangeIterator<>(target, listIterator());
    }
    
    public RangeSet<T> negate(Range<T> target) {
        return new RangeSet<>(toStream(negateIterator(target)).collect(toList()));
    }
    
    public Iterator<Range<T>> maskIterator(ListIterator<Range<T>> another, Range<T> range) {
        return new RangeIntersectsRangeIterator<>(another, Iterators.buffer(negateIterator(range), 2));
    }
    
    public Iterator<Range<T>> maskedIterator(ListIterator<Range<T>> another, Range<T> range) {
        return this.intersectIterator(Iterators.buffer(new NegateRangeIterator<>(range, another), 2));
    }
    
    public Iterator<Range<T>> maskedIterator(ListIterator<Range<T>> another) {
        return maskedIterator(another, this.cover());
    }
    
    public Iterator<Range<T>> maskIterator(ListIterator<Range<T>> another) {
        return maskIterator(another, this.cover());
    }
    
    public RangeSet<T> maskedBy(RangeSet<T> another) {
        return new RangeSet<>(toStream(maskedIterator(another.listIterator())).collect(toList()));
    }
    
    public RangeSet<T> mask(RangeSet<T> another) {
        return new RangeSet<>(toStream(maskIterator(another.listIterator(), another.cover())).collect(toList()));
    }
    
    public Range<T> cover() {
        if (elements.isEmpty())
            return new Empty();
        if (elements.size() == 1)
            return elements.get(0);
        return elements.get(0).cover(elements.get(elements.size() - 1));
    }
    
    public Iterator<Range<T>> unionIterator(RangeSet<T> another) {
        Range<T> whole = cover().cover(another.cover());
        return new NegateRangeIterator<>(whole, 
            Iterators.buffer(new RangeIntersectsRangeIterator<>(
                    Iterators.buffer(this.negateIterator(whole), 2), 
                    Iterators.buffer(another.negateIterator(whole), 2)), 2));
    }
    
    public RangeSet<T> union(RangeSet<T> another) {
        return new RangeSet<>(toStream(unionIterator(another)).collect(toList()));
    }
        
    @Override
    public String toString() {
        return Format.concat(elements, ",", "");
    }
}
