/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import java.util.ListIterator;

/**
 *
 * @author mtomono
 * @param <T>
 */
public class PointContainsPointIterator<T extends Comparable<T>> extends ForAllRightWalker<T, T> {
    Order<T> order;
    
    public PointContainsPointIterator(Order<T> order, ListIterator<T> left, ListIterator<T> right) {
        super(left, right);
        this.order = order;
    }
    
    public PointContainsPointIterator(ListIterator<T> left, ListIterator<T> right) {
        this(Default.order, left, right);
    }
    
    @Override
    public boolean leftCatchesRight(T left, T right) {
        return order.ge(left, right);
    }

    @Override
    public boolean matches(T left, T right) {
        return order.eq(left, right);
    }

    @Override
    public boolean doesRightStay(T left, T right) {
        return false;
    }
}
