/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 * a listiterator which only can previous() once at a time.
 * @author mtomono
 */
public class SingleBufferedListIterator<T> extends BufferedListIterator<T> {
    Iterator<T> body;
    T current;
    boolean buffered;
    boolean skip;
    
    public SingleBufferedListIterator(Iterator<T> body) {
        this.body = body;
        this.skip = false;
        this.buffered = false;
    }
    
    @Override
    public boolean hasPrevious() {
        return !skip && buffered;
    }

    @Override
    public T previous() {
        if (!hasPrevious())
            throw new NoSuchElementException();
        this.skip = true;
        return current;
    }
    
    @Override
    public boolean hasNext() {
        return skip || body.hasNext();
    }

    @Override
    public T next() {
        buffered = true;
        if (!skip)
            current = body.next();
        skip = false;
        return current;
    }
}
