/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package grammar.action;

import context.IContext;
import grammar.Grammar;
import parser.ParseResult;

/**
 * Reduce that does not leave a ParseResult. Though this put a ParseResult
 * on the context in init() so to remove any intermediate result when fail()s.
 * and when match(), this will give all the result into upper ParseResult and removes
 * the ParseResult of its own. 
 * Thus I call it naked.
 * and this is the difference between omitTree where it removes all the result.
 * @author mtomono
 */
public class NakedTree extends Branch {

    @Override
    public void match(IContext<?> context, int start, int end, Grammar origin) {
        ParseResult retval = context.stack().pop();
        retval.setRange(start, end);
        if (!context.stack().isEmpty())
            context.stack().peek().addAll(retval);
    }
    
    @Override
    public String toString() {
        return "@";
    }
}
