/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package grammar.action;

import context.IContext;
import grammar.Action;
import grammar.Grammar;
import parser.ParseResult;

/**
 * This type of action manipulates branch made of ParseResult
 * @author mtomono
 */
abstract public class Branch implements Action {
    @Override
    public void init(IContext<?> context, Grammar origin) {
        context.stack().push(new ParseResult(origin));
    }

    @Override
    public void fail(IContext<?> context, Grammar origin) {
        context.stack().pop();
    }
}
