/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package grammar;

import grammar.action.NakedTree;
import grammar.action.ContextLeaf;
import grammar.action.BuildRange;
import grammar.action.BuildTree;
import grammar.action.OmitTree;
import context.IContext;
import static debug.Trace.*;

/**
 *
 * @author mtomono
 * @param <E>
 */
public abstract class Grammar<E> {
    final static public Action Tree = new BuildTree();
    final static public Action None = new SeqAction();
    final static public Action Range = BuildRange.c();
    final static public Action Omit = new OmitTree();
    final static public Action RangeTree = new SeqAction(Omit, Range);
    final static public Action Naked = new NakedTree();
    final static public Action Now = new ContextLeaf(n->n.now());
    final static public Action NowTree = new SeqAction(Now, Tree);
    
    Action action = Tree;

    public Grammar with(Action action) {
        assert action != null;
        this.action = action;
        return this;
    }
    
    abstract public boolean match(IContext<E> target);
    abstract public int minLength();
    
    public boolean parseEntry(IContext<E> target) {
        boolean retval;
        assert target.trace.l(s("---- start ----"));
        retval = parse(target);
        assert target.trace.l(s("---- finish ----"));
        assert target.trace.cr();
        return retval;
    }
    
    boolean parse(IContext<E> target) {
        assert target.trace.u(s("=>", target.save(), "--"), clazz(this));
        boolean retval = parseCore(target);
        assert target.trace.d(s("<=", target.save(), "--"), clazz(this) , s(" : ", retval));
        return retval;
    }
    
    boolean parseCore(IContext<E> target) {
        action.init(target, this);
        int current = target.save();
        if (match(target)) {
            action.match(target, current, target.save(), this);
            return true;
        }
        action.fail(target, this);
        target.load(current);
        return false;
    }
    
    abstract public String bodyToString();
    
    @Override
    public String toString() {
        return bodyToString() + "#" + action.toString();
    }
}
