/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package grammar.action;

import context.IContext;
import grammar.Action;
import grammar.Grammar;

/**
 * This type of action creates/puts an Object into branch made of ParseResult
 * @author mtomono
 */
abstract public class Leaf implements Action {
    
    @Override
    public void init(IContext<?> context, Grammar origin) {
    }
    
    @Override
    public void match(IContext<?> context, int start, int end, Grammar origin) {
        context.stack().peek().add(leaf(context, start, end));
    }
    
    abstract public Object leaf(IContext<?> context, int start, int end);
    
    @Override
    public void fail(IContext<?> context, Grammar origin) {
    }
}
