/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package function;

import java.util.List;
import java.util.function.BiFunction;
import static java.util.stream.Collectors.toList;

/**
 *
 * @author mtomono
 */
public class Accum<T, R> {
    T body;
    R accumulation;
    
    public Accum(T body, R accum) {
        this.body = body;
        this.accumulation = accum;
    }
    
    public T body() {
        return body;
    }
    
    public R a() {
        return accumulation;
    }
    
    static public <T, R> List<Accum<T, R>> accumulate(List<T> target, R init, BiFunction<T, R, R> func) {
        Holder<R> h = new Holder<>(init);
        return target.stream().map(t->new Accum<>(t, h.set(func.apply(t, h.get())))).collect(toList());
    }
}
