/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: devicemanagerCP.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

#ifndef _ATLDEVICEMANAGERCP_H_
#define _ATLDEVICEMANAGERCP_H_

template <class T>
class CProxy_IKernelEvents : public IConnectionPointImpl<T, &IID__IKernelEvents, CComDynamicUnkArray>
{
	//Warning this class may be recreated by the wizard.
public:
	HRESULT Fire_OnInterruptRequest(ULONG inhno)
	{
		HRESULT ret;
		T* pT = static_cast<T*>(this);
		int nConnectionIndex;
		int nConnections = m_vec.GetSize();
		
		for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
		{
			pT->Lock();
			CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
			pT->Unlock();
			_IKernelEvents* p_IKernelEvents = reinterpret_cast<_IKernelEvents*>(sp.p);
			if (p_IKernelEvents != NULL)
				ret = p_IKernelEvents->OnInterruptRequest(inhno);
		}	return ret;
	
	}
};




template <class T>
class CProxy_IDeviceEvents : public IConnectionPointImpl<T, &IID__IDeviceEvents, CComDynamicUnkArray>
{
	//Warning this class may be recreated by the wizard.
public:
	HRESULT Fire_OnRead(LONG address, LONG sz, unsigned char * data)
	{
		HRESULT ret;
		T* pT = static_cast<T*>(this);
		int nConnectionIndex;
		int nConnections = m_vec.GetSize();
		
		for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
		{
			pT->Lock();
			CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
			pT->Unlock();
			_IDeviceEvents* p_IDeviceEvents = reinterpret_cast<_IDeviceEvents*>(sp.p);
			if (p_IDeviceEvents != NULL)
				ret = p_IDeviceEvents->OnRead(address, sz, data);
		}	return ret;
	
	}
	HRESULT Fire_OnWrite(LONG address, LONG sz, unsigned char * data)
	{
		HRESULT ret;
		T* pT = static_cast<T*>(this);
		int nConnectionIndex;
		int nConnections = m_vec.GetSize();
		
		for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
		{
			pT->Lock();
			CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
			pT->Unlock();
			_IDeviceEvents* p_IDeviceEvents = reinterpret_cast<_IDeviceEvents*>(sp.p);
			if (p_IDeviceEvents != NULL)
				ret = p_IDeviceEvents->OnWrite(address, sz,data);
		}	return ret;
	
	}
	HRESULT Fire_OnKernelStart()
	{
		HRESULT ret;
		T* pT = static_cast<T*>(this);
		int nConnectionIndex;
		int nConnections = m_vec.GetSize();
		
		for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
		{
			pT->Lock();
			CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
			pT->Unlock();
			_IDeviceEvents* p_IDeviceEvents = reinterpret_cast<_IDeviceEvents*>(sp.p);
			if (p_IDeviceEvents != NULL)
				ret = p_IDeviceEvents->OnKernelStart();
		}	return ret;
	
	}
	HRESULT Fire_OnKernelExit()
	{
		HRESULT ret;
		T* pT = static_cast<T*>(this);
		int nConnectionIndex;
		int nConnections = m_vec.GetSize();
		
		for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
		{
			pT->Lock();
			CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
			pT->Unlock();
			_IDeviceEvents* p_IDeviceEvents = reinterpret_cast<_IDeviceEvents*>(sp.p);
			if (p_IDeviceEvents != NULL)
				ret = p_IDeviceEvents->OnKernelExit();
		}	return ret;
	
	}
};




template <class T>
class CProxy_IInformationEvents : public IConnectionPointImpl<T, &IID__IInformationEvents, CComDynamicUnkArray>
{
	//Warning this class may be recreated by the wizard.
public:
	HRESULT Fire_OnDeviceChanged(SHORT reason, LONG devid, LONG extra = 0)
	{
		HRESULT ret;
		T* pT = static_cast<T*>(this);
		int nConnectionIndex;
		int nConnections = m_vec.GetSize();
		
		for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
		{
			pT->Lock();
			CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
			pT->Unlock();
			_IInformationEvents* p_IInformationEvents = reinterpret_cast<_IInformationEvents*>(sp.p);
			if (p_IInformationEvents != NULL)
				ret = p_IInformationEvents->OnDeviceChanged(reason, devid, extra);
		}	return ret;
	
	}
	HRESULT Fire_OnKernelChanged(SHORT reason)
	{
		HRESULT ret;
		T* pT = static_cast<T*>(this);
		int nConnectionIndex;
		int nConnections = m_vec.GetSize();
		
		for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
		{
			pT->Lock();
			CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
			pT->Unlock();
			_IInformationEvents* p_IInformationEvents = reinterpret_cast<_IInformationEvents*>(sp.p);
			if (p_IInformationEvents != NULL)
				ret = p_IInformationEvents->OnKernelChanged(reason);
		}	return ret;
	
	}
};


template <class T>
class CProxy_IKernelLogEvents : public IConnectionPointImpl<T, &IID__IKernelLogEvents, CComDynamicUnkArray>
{
public:
	bool onKernelStart_Performed;

	CProxy_IKernelLogEvents(void) : onKernelStart_Performed(false) {};

	//Warning this class may be recreated by the wizard.
public:
	HRESULT Fire_OnKernelStart()
	{
		HRESULT ret;
		T* pT = static_cast<T*>(this);
		int nConnectionIndex;
		int nConnections = m_vec.GetSize();
		
		for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
		{
			pT->Lock();
			CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
			pT->Unlock();
			_IKernelLogEvents* p_IKernelLogEvents = reinterpret_cast<_IKernelLogEvents*>(sp.p);
			if (p_IKernelLogEvents != NULL)
			{
				if((ret = p_IKernelLogEvents->OnKernelStart()) == S_OK)
					onKernelStart_Performed = true;
			}
		}
		return ret;
	}

	HRESULT Fire_OnKernelExit()
	{
		HRESULT ret;
		T* pT = static_cast<T*>(this);
		int nConnectionIndex;
		int nConnections = m_vec.GetSize();
		
		for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
		{
			pT->Lock();
			CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
			pT->Unlock();
			_IKernelLogEvents* p_IKernelLogEvents = reinterpret_cast<_IKernelLogEvents*>(sp.p);
			if (p_IKernelLogEvents != NULL)
				ret = p_IKernelLogEvents->OnKernelExit();
		}
		onKernelStart_Performed = false;	
		return ret;
	}

	HRESULT Fire_OnLogEvent(LONG sz, unsigned char * data)
	{
		HRESULT ret;
		T* pT = static_cast<T*>(this);
		int nConnectionIndex;
		int nConnections = m_vec.GetSize();
		
		for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
		{
			pT->Lock();
			CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
			pT->Unlock();
			_IKernelLogEvents* p_IKernelLogEvents = reinterpret_cast<_IKernelLogEvents*>(sp.p);
			if (p_IKernelLogEvents != NULL)
			{
				if(!onKernelStart_Performed)
					p_IKernelLogEvents->OnKernelStart();
				ret = p_IKernelLogEvents->OnLogEvent(sz, data);
			}
		}
		if(nConnectionIndex != 0)
			onKernelStart_Performed = true;	
		return ret;	
	}
};
#endif
