/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: t_syslog.h,v 1.1 2008/06/17 00:04:43 suikan Exp $
 */

/*
 *	VXeO@\
 *
 *  VXeOT[rX́CVXẽOo͂邽߂̃T[rX
 *  łDJ[l̃Ȍo͂ɂp邽߁Cő҂
 *  ɂ͂邱Ƃ͂ȂD
 *
 *  ÓCJ[l̃Oobt@ɏނC჌x̕o
 *  ͊֐pďo͂DǂǵCgT[rXR[Ő؂
 *  邱ƂłD
 *
 *  Oobt@̈悪I[ot[ꍇɂ́CÂOď
 *  D
 *
 *  AZũ\[Xt@CVXeRtBM[Vt@
 *  C炱̃t@CCN[h鎞́C_MACRO_ONLY `
 *  ƂŁC}N`ȊŐLqƂłD
 *
 *  ̃CN[ht@ĆCkernel.h  sil.h ŃCN[hD
 *  ̃t@C璼ڃCN[h邱Ƃ͂ȂD
 *
 *  ̃t@CCN[hOɁCt_stddef.h  itron.h CN
 *  [hĂƂKvłD
 */

#ifndef _T_SYSLOG_H_
#define _T_SYSLOG_H_

/*
 *  O̎ʂ̒`
 *
 *  LOG_TYPE_CYCCLOG_TYPE_ASSERT ȊÓCfobMOC^tF[Xd
 *  lƍvĂD
 */
#define LOG_TYPE_INH		0x01u	/* ݃nh */
#define LOG_TYPE_ISR		0x02u	/* ݃T[rX[` */
#define LOG_TYPE_CYC		0x03u	/* nh */
#define LOG_TYPE_EXC		0x04u	/* CPUOnh */
#define LOG_TYPE_TEX		0x05u	/* ^XNO[` */
#define LOG_TYPE_TSKSTAT	0x06u	/* ^XNԕω */
#define LOG_TYPE_DSP		0x07u	/* fBXpb` */
#define LOG_TYPE_SVC		0x08u	/* T[rXR[ */
#define LOG_TYPE_COMMENT	0x09u	/* Rg */
#define LOG_TYPE_ASSERT		0x0au	/* AT[V̎s */

#define LOG_ENTER		0x00u	/* ^Jn */
#define LOG_LEAVE		0x80u	/* o^I */

/*
 *  Ȍdvx̒`
 */
#define LOG_EMERG	0u		/* Vbg_EɒlG[ */
#define LOG_ALERT	1u
#define LOG_CRIT	2u
#define LOG_ERROR	3u		/* VXeG[ */
#define LOG_WARNING	4u		/* xbZ[W */
#define LOG_NOTICE	5u
#define LOG_INFO	6u
#define LOG_DEBUG	7u		/* fobOpbZ[W */

#ifndef _MACRO_ONLY

/*
 *  Õf[^\
 */

#define TMAX_LOGINFO	6

typedef struct {
		UINT	logtype;		/* O̎ */
		SYSTIM	logtim;			/* O */
		VP_INT	loginfo[TMAX_LOGINFO];	/* ̑̃O */
	} SYSLOG;

/*
 *  Ȍdvx̃rbg}bv邽߂̃}N
 */
#define LOG_MASK(prio)	(1u << (prio))
#define LOG_UPTO(prio)	((1u << ((prio) + 1)) - 1)

#ifndef OMIT_SYSLOG

/*
 *  Ȍo
 */
extern ER	vwri_log(UINT prio, SYSLOG *p_log) throw();

/*
 *  Oobt@̃O̓Ǐo
 */
extern ER_UINT	vrea_log(SYSLOG *p_log) throw();

/* 
 *  oׂ͂Ȍdvx̐ݒ
 */
extern ER	vmsk_log(UINT logmask, UINT lowmask) throw();

/*
 *  Oo͂邽߂̃Cu֐
 */

Inline ER
_syslog_0(UINT prio, UINT type)
{
	SYSLOG	log;

	log.logtype = type;
	return(vwri_log(prio, &log));
}

Inline ER
_syslog_1(UINT prio, UINT type, VP_INT arg1)
{
	SYSLOG	log;

	log.logtype = type;
	log.loginfo[0] = arg1;
	return(vwri_log(prio, &log));
}

Inline ER
_syslog_2(UINT prio, UINT type, VP_INT arg1, VP_INT arg2)
{
	SYSLOG	log;

	log.logtype = type;
	log.loginfo[0] = arg1;
	log.loginfo[1] = arg2;
	return(vwri_log(prio, &log));
}

Inline ER
_syslog_3(UINT prio, UINT type, VP_INT arg1, VP_INT arg2, VP_INT arg3)
{
	SYSLOG	log;

	log.logtype = type;
	log.loginfo[0] = arg1;
	log.loginfo[1] = arg2;
	log.loginfo[2] = arg3;
	return(vwri_log(prio, &log));
}

Inline ER
_syslog_4(UINT prio, UINT type, VP_INT arg1, VP_INT arg2,
				VP_INT arg3, VP_INT arg4)
{
	SYSLOG	log;

	log.logtype = type;
	log.loginfo[0] = arg1;
	log.loginfo[1] = arg2;
	log.loginfo[2] = arg3;
	log.loginfo[3] = arg4;
	return(vwri_log(prio, &log));
}

Inline ER
_syslog_5(UINT prio, UINT type, VP_INT arg1, VP_INT arg2,
				VP_INT arg3, VP_INT arg4, VP_INT arg5)
{
	SYSLOG	log;

	log.logtype = type;
	log.loginfo[0] = arg1;
	log.loginfo[1] = arg2;
	log.loginfo[2] = arg3;
	log.loginfo[3] = arg4;
	log.loginfo[4] = arg5;
	return(vwri_log(prio, &log));
}

Inline ER
_syslog_6(UINT prio, UINT type, VP_INT arg1, VP_INT arg2, VP_INT arg3,
				VP_INT arg4, VP_INT arg5, VP_INT arg6)
{
	SYSLOG	log;

	log.logtype = type;
	log.loginfo[0] = arg1;
	log.loginfo[1] = arg2;
	log.loginfo[2] = arg3;
	log.loginfo[3] = arg4;
	log.loginfo[4] = arg5;
	log.loginfo[5] = arg6;
	return(vwri_log(prio, &log));
}

#else /* OMIT_SYSLOG */

#define vwri_log(prio, p_log)		E_OK
#define vrea_log(p_log)			E_OK
#define vmsk_log(logmask, lowmask)	E_OK

#define _syslog_0(prio, type)						E_OK
#define _syslog_1(prio, type, arg1)					E_OK
#define _syslog_2(prio, type, arg1, arg2)				E_OK
#define _syslog_3(prio, type, arg1, arg2, arg3)				E_OK
#define _syslog_4(prio, type, arg1, arg2, arg3, arg4)			E_OK
#define _syslog_5(prio, type, arg1, arg2, arg3, arg4, arg5)		E_OK
#define _syslog_6(prio, type, arg1, arg2, arg3, arg4, arg5, arg6)	E_OK

#endif /* OMIT_SYSLOG */

/*
 *  OiRgjo͂邽߂̃}N
 *
 *  format ь㑱̈쐬bZ[WCdx prio 
 *  OƂďo͂邽߂̃}NDarg1`argn  VP_INT^ɃL
 *  Xg邽߁CVP_INT^Ɍ^ϊłCӂ̌^ł悢D
 */

#define	syslog_0(prio, format) \
		_syslog_1(prio, LOG_TYPE_COMMENT, (VP_INT) format)

#define	syslog_1(prio, format, arg1) \
		_syslog_2(prio, LOG_TYPE_COMMENT, (VP_INT) format, \
							(VP_INT)(arg1))

#define	syslog_2(prio, format, arg1, arg2) \
		_syslog_3(prio, LOG_TYPE_COMMENT, (VP_INT) format, \
					(VP_INT)(arg1), (VP_INT)(arg2))

#define	syslog_3(prio, format, arg1, arg2, arg3) \
		_syslog_4(prio, LOG_TYPE_COMMENT, (VP_INT) format, \
			(VP_INT)(arg1), (VP_INT)(arg2), (VP_INT)(arg3))

#define	syslog_4(prio, format, arg1, arg2, arg3, arg4) \
		_syslog_5(prio, LOG_TYPE_COMMENT, (VP_INT) format, \
			(VP_INT)(arg1), (VP_INT)(arg2), (VP_INT)(arg3), \
							(VP_INT)(arg4))

#define	syslog_5(prio, format, arg1, arg2, arg3, arg4, arg5) \
		_syslog_6(prio, LOG_TYPE_COMMENT, (VP_INT) format, \
			(VP_INT)(arg1), (VP_INT)(arg2), (VP_INT)(arg3), \
					(VP_INT)(arg4), (VP_INT)(arg5))

/*
 *  OiRgjo͂邽߂̃Cu֐ivasyslog.cj
 */
extern ER	syslog(UINT prio, const char *format, ...) throw();

/* 
 *  ÕtH[}bgóilog_output.cj
 */
extern void	syslog_printf(const char *format, VP_INT *args,
						void (*putc)(char)) throw();
extern void	syslog_print(SYSLOG *p_log, void (*putc)(char)) throw();
extern void	syslog_output(void (*putc)(char)) throw();

#endif /* _MACRO_ONLY */
#endif /* _T_SYSLOG_H_ */
