/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: t_services.h,v 1.1 2008/06/17 00:04:43 suikan Exp $
 */

/*
 *	AvP[Vp WCN[ht@C
 *
 *  ̃CN[ht@ĆCJ[lœ삷vÕ\[X
 *  t@CŃCN[hWCN[ht@CłD̒ŁC
 *  kernel.hiɂCt_stddef.hCitron.hCtool_defs.hC
 *  sys_defs.hCcpu_defs.hCt_syslog.hjserial.hCN[hĂ
 *  D܂CAvP[VɗLvƎv`܂łD
 *
 *  AZũ\[Xt@CVXeRtBM[Vt@
 *  C炱̃t@CCN[h鎞́C_MACRO_ONLY `
 *  ƂŁC}N`ȊŐLqƂłD
 */

#ifndef _T_SERVICES_H_
#define _T_SERVICES_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  J[lĂяo߂ɕKvȃCN[ht@C
 */
#include <kernel.h>

#ifndef _MACRO_ONLY

/*
 *  VAC^tF[XW[
 */
#include <serial.h>

/*
 *  J[l̏I
 */
extern void	kernel_exit(void) throw();

/*
 *  syscall}NC_syscall }N̒`
 */

extern void	t_perror(UINT prio, const char *file, int line,
					const char *expr, ER ercd) throw();

Inline ER
_t_perror(const char *file, int line, const char *expr, ER ercd)
{
	if (ercd < 0) {
		t_perror(LOG_ERROR, file, line, expr, ercd);
	}
	return(ercd);
}

Inline ER
_t_panic(const char *file, int line, const char *expr, ER ercd)
{
	if (ercd < 0) {
		t_perror(LOG_EMERG, file, line, expr, ercd);
		kernel_abort();
	}
	return(ercd);
}

#define syscall(s)	_t_perror(__FILE__, __LINE__, #s, (s))
#define _syscall(s)	_t_panic(__FILE__, __LINE__, #s, (s))

#endif /* _MACRO_ONLY */

#ifdef __cplusplus
}
#endif

#endif /* _T_SERVICES_H_ */
