/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: linux_sigio.h,v 1.1 2008/06/17 00:04:43 suikan Exp $
 */

/*
 *  LINUXp mubLOI/O T|[gW[
 *
 *  mubLOI/O T|[gW[́CSIGIO VOiɂC[
 *  Uo^R[obN֐Ăяo@\D
 *
 *  SIGIO VOiɂR[obN֐sꍇɂ́CSIGIO 
 *  ʒmCxgubNpӂC callback tB[hɃR[ob
 *  N֐Carg tB[hɃR[obN֐֓nݒ肵C
 *  eneuque_sigioeb p SIGIO ʒmCxgL[ɓo^D
 *
 *  ĂяoꂽR[obN֐ 0 ԂƁC֘A SIGIO ʒmCx
 *  gubN ̓L[ɓo^ꂽ܂܂ƂȂC SIGIO VOi
 *  ĂѓR[ obN֐ĂяoDR[obN֐ 0 ȊO
 *  ԂƁCSIGIO ʒmCxgubN̓L[폜CR[ob
 *  N֐͂ȍ~ĂяoȂȂD
 */

#ifndef	_LINUX_SIGIO_H_
#define	_LINUX_SIGIO_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  SIGIO ʒmCxgubN̒`
 */
typedef BOOL	(*SIGIO_CBACK)(VP);	/* SIGIO R[obN֐̌^ */

typedef struct bsd_sigio_event_block {
	VP		queue[2];	/* SIGIO ʒmCxgL[GA */
	SIGIO_CBACK	callback;	/* SIGIO R[obN֐ */
	VP		arg;		/* R[obN֐֓n */
} SIGIOEB;

/*
 *  SIGIO ʒmCxgubN̓o^
 */
extern ER	enqueue_sigioeb(SIGIOEB *sigioeb) throw();

/*
 *  VXeNp SIGIO ʒmCxgubN̓o^
 */
extern ER	enqueue_sigioeb_initialize(SIGIOEB *sigioeb) throw();

/*
 *   mubLOI/O W[N[`
 */

extern void linux_sigio_initialize(VP_INT exinf) throw();

/*
 *  ݃nh̃xN^ԍ
 */
#define	INHNO_SIGIO	SIGIO

/*
 *  SIGIO荞݃nh
 */

extern void linux_sigio_handler() throw();
    
/*
 * SIGIO^XN̐ݒ
 */
#define LINUX_SIGIO_PRIORITY      2
#define LINUX_SIGIO_STACK_SIZE 8192

extern void linux_sigio_task(void) throw();

#ifdef __cplusplus
}
#endif

#endif /* _LINUX_SIGIO_H_ */
