/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2005 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *  VAI/OfoCXiSIOjhCoiXstormy16pj
 */

#include <kernel.h>
#include <s_services.h>
#include <hw_serial.h>
#include <cpu_sfrs.h>

/*
 *  񓯊MłTxReadỹ^CAEg
 */
#define TXREADY_TIMEOUT 400

/*
 *  SIOPCB*`FbN̂߂̃}WbNl
 */
#define MAGIC_SIOPCB 0xabcd

/*
 *  VAI/O|[gǗubÑGA
 */
static SIOPCB siopcb_table[TNUM_PORT] = {
    { MAGIC_SIOPCB, __U0CR, 0x1400 },
    { MAGIC_SIOPCB, __U1CR, 0x4800 },
} ;

/*
 *  SIOhCȍ[`
 */
void sio_initialize(void)
{
    /* nothing to do here */
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *sio_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB* siopcb ;
    UH uhBase ;
                                /*
                                 *  I[vo|[g̃`FbN
                                 */
    if ( siopid < 1 || siopid > TNUM_PORT ) return NULL ;
    siopcb = &siopcb_table[siopid-1] ;
    if ( siopcb->bNotExist ) return NULL ;
                                /*
                                 *  ɃI[vς݂̏ꍇ
                                 */
    if ( siopcb->bOpened ) {
        siopcb->vpiExinf = exinf ;
        return siopcb ;
    }
                                /*
                                 *  SIȌƑ݂̃`FbN
                                 */
    uhBase = siopcb->uhBase ;
    __SFR(uhBase) = __UxCR_RUN|__UxCR_TXEMPTY ;
    if ( ( __SFR(uhBase) &
        ( __UxCR_RUN|__UxCR_BAUDRATE|__UxCR_PARITY|__UxCR_TXIE|
        __UxCR_RXIE) ) != __UxCR_RUN ) {
        siopcb->bNotExist = TRUE ;
        return NULL ;
    }
                                /*
                                 *  Ǘe[ȕ
                                 */
    siopcb->vpiExinf = exinf ;
    siopcb->bOpened = TRUE ;
    siopcb->bTxIe = FALSE ;
    siopcb->bRxIe = FALSE ;
    siopcb->bLastIsCr = FALSE ;
                                /*
                                 *  荞݃nh̓o^Ƌ
                                 */
    define_inh( INHNO_SIO, sio_handler ) ;
    __UNLOCK_EXCP() ;
    __SFRW(__EXCPL) |= siopcb->uhExcpMask ;
    __LOCK_EXCP() ;
    return siopcb ;
}

/*
 *  VAI/O|[g̃N[Y
 */
void sio_cls_por(SIOPCB *siopcb)
{
                                /*
                                 *  N[Yo|[g̃`FbN
                                 */
    if ( !siopcb || siopcb->uhMagic != MAGIC_SIOPCB ||
        siopcb->bNotExist || !siopcb->bOpened ) return ;
                                /*
                                 *  Ǘe[u̕ύX
                                 */
    siopcb->bOpened = FALSE ;
                                /*
                                 *  荞݂̋֎~
                                 */
    __UNLOCK_EXCP() ;
    __SFRW(__EXCPL) &= ~siopcb->uhExcpMask ;
    __LOCK_EXCP() ;
                                /*
                                 *  SIO̒~
                                 */
    __SFR(siopcb->uhBase) = 0 ;
}

/*
 *  SIO̊݃nh
 */
void sio_handler(void)
{
                                /*
                                 *  SẴ|[gɂă`FbN
                                 */
    ID portid ;
    for ( portid = 0 ; portid < TNUM_PORT ; portid++ ) {
        SIOPCB *siopcb = &siopcb_table[portid] ;
        UH uhBase = siopcb->uhBase ;
                                /*
                                 *  M荞݂
                                 */
        if ( ( __SFR(uhBase) & ( __UxCR_TXIE | __UxCR_TXEMPTY ) ) ==
            ( __UxCR_TXIE | __UxCR_TXEMPTY ) ) {
            sio_ierdy_snd( siopcb->vpiExinf ) ;
        }
                                /*
                                 *  M荞݂
                                 */
        if ( ( __SFR(uhBase) & ( __UxCR_RXIE | __UxCR_RXREADY ) ) ==
            ( __UxCR_RXIE | __UxCR_RXREADY ) ) {
            sio_ierdy_rcv( siopcb->vpiExinf ) ;
        }
    }
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL sio_snd_chr(SIOPCB *siopcb, char c)
{
    UH uhBase ;
                                /*
                                 *  Lȃ|[gǂ̃`FbN
                                 */
    if ( !siopcb || siopcb->uhMagic != MAGIC_SIOPCB ||
        siopcb->bNotExist || !siopcb->bOpened ) return FALSE ;
    uhBase = siopcb->uhBase ;
                                /*
                                 *  M\ǂ̃`FbN
                                 */
    if ( ! ( __SFR(uhBase) & __UxCR_TXEMPTY ) ) return FALSE ;
                                /*
                                 *  Mf[^̏
                                 */
    __SFRW(uhBase+4) = __UxTX_STOPBIT | c ;
    return TRUE ;
}

/*
 *  VAI/O|[g̕M
 */
INT sio_rcv_chr(SIOPCB *siopcb)
{
    UH uhBase ;
                                /*
                                 *  Lȃ|[gǂ̃`FbN
                                 */
    if ( !siopcb || siopcb->uhMagic != MAGIC_SIOPCB ||
        siopcb->bNotExist || !siopcb->bOpened ) return -1 ;
    uhBase = siopcb->uhBase ;
                                /*
                                 *  Mf[^L̃`FbN
                                 */
    if ( ! ( __SFR(uhBase) & __UxCR_RXREADY ) ) return -1 ;
                                /*
                                 *  Mf[^̎o
                                 */
    return __SFRW(uhBase+2) & 0xff ;
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void sio_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    UH uhBase ;
                                /*
                                 *  Lȃ|[gǂ̃`FbN
                                 */
    if ( !siopcb || siopcb->uhMagic != MAGIC_SIOPCB ||
        siopcb->bNotExist || !siopcb->bOpened ) return ;
    uhBase = siopcb->uhBase ;
                                /*
                                 *  M荞݂̋
                                 */
    if ( cbrtn == SIO_ERDY_SND ) {
        __SFR(uhBase) |= __UxCR_TXIE ;
        siopcb->bTxIe = TRUE ;
    }
                                /*
                                 *  M荞݂̋
                                 */
    if ( cbrtn == SIO_ERDY_RCV ) {
        __SFR(uhBase) |= __UxCR_RXIE ;
        siopcb->bRxIe = TRUE ;
    }
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void sio_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    UH uhBase ;
                                /*
                                 *  Lȃ|[gǂ̃`FbN
                                 */
    if ( !siopcb || siopcb->uhMagic != MAGIC_SIOPCB ||
        siopcb->bNotExist || !siopcb->bOpened ) return ;
    uhBase = siopcb->uhBase ;
                                /*
                                 *  M荞݂̋֎~
                                 */
    if ( cbrtn == SIO_ERDY_SND ) {
        __SFR(uhBase) &= ~__UxCR_TXIE ;
        siopcb->bTxIe = FALSE ;
    }
                                /*
                                 *  M荞݂̋֎~
                                 */
    if ( cbrtn == SIO_ERDY_RCV ) {
        __SFR(uhBase) &= ~__UxCR_RXIE ;
        siopcb->bRxIe = FALSE ;
    }
}

/*
 *  ftHg̑M\R[obN
 */
void sio_ierdy_snd(VP_INT exinf) __attribute__((__weak__)) ;
void sio_ierdy_snd(VP_INT exinf)
{
}

/*
 *  ftHg̎MʒmR[obN
 */
void sio_ierdy_rcv(VP_INT exinf) __attribute__((__weak__)) ;
void sio_ierdy_rcv(VP_INT exinf)
{
}

/*
 *  VAI/O|[gւ̔񓯊o
 */
void sio_asnd_chr( INT c )
{
    SIOPCB* siopcb ;
    UH uhBase ;
    int i ;
                                /*
                                 *  CPUbNԂɂ
                                 */
    BOOL bLocked ;
    if ( sns_loc() ) bLocked = TRUE ;
    else {
        bLocked = FALSE ;
        if ( sns_ctx() ) iloc_cpu() ;
        else loc_cpu() ;
    }
                                /*
                                 *  񓯊p|[gJ
                                 */
    if ( ( siopcb = sio_opn_por( LOGTASK_PORTID,
        siopcb_table[LOGTASK_PORTID-1].vpiExinf ) ) != NULL ) {
        uhBase = siopcb->uhBase ;
                                /*
                                 *  LFȂ܂CR𑗏o
                                 */
        if ( c == '\n' ) {
            for ( i = 0 ; i < TXREADY_TIMEOUT ; i++ ) {
                if ( __SFR(uhBase) & __UxCR_TXEMPTY ) break ;
            }
            if ( i < TXREADY_TIMEOUT ) {
                __SFRW(uhBase+4) = __UxTX_STOPBIT | '\r' ;
            }
        }
                                /*
                                 *  f[^o
                                 */
        for ( i = 0 ; i < TXREADY_TIMEOUT ; i++ ) {
            if ( __SFR(uhBase) & __UxCR_TXEMPTY ) break ;
        }
        if ( i < TXREADY_TIMEOUT ) {
            __SFRW(uhBase+4) = __UxTX_STOPBIT | c ;
        }
    }
                                /*
                                 *  CPUbNɖ߂
                                 */
    if ( !bLocked ) {
        if ( sns_ctx() ) iunl_cpu() ;
        else unl_cpu() ;
    }
}

/*
 *  VAI/O|[g̔񓯊
 */
INT sio_arcv_chr( void )
{
    SIOPCB* siopcb ;
    UH uhBase ;
    INT c = -1 ;
                                /*
                                 *  ^XNReLXĝݎgp
                                 */
    if ( sns_ctx() || sns_loc() || sns_dsp() ) return -1 ;
                                /*
                                 *  CPUbNԂɂ
                                 */
    loc_cpu() ;
                                /*
                                 *  񓯊p|[gJ
                                 */
    if ( ( siopcb = sio_opn_por( LOGTASK_PORTID,
        siopcb_table[LOGTASK_PORTID-1].vpiExinf ) ) != NULL ) {
        uhBase = siopcb->uhBase ;
                                /*
                                 *  M҂
                                 */
        while(1) {
            if ( __SFR(uhBase) & __UxCR_RXREADY ) {
                c = __SFRW(uhBase+2) & 0xff ;
                if ( c == '\r' ) {
                    c = '\n' ;
                    siopcb->bLastIsCr = TRUE ;
                }
                else {
                    if ( c == '\n' && siopcb->bLastIsCr ) c = -1 ;
                    siopcb->bLastIsCr = FALSE ;
                }
            }
            if ( c != -1 ) break ;
            unl_cpu() ;
            dly_tsk( 50 ) ;
            loc_cpu() ;
        }
    }
                                /*
                                 *  CPUbN
                                 */
    unl_cpu() ;
    return c ;
}

