/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_serial.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */



/*
 *  TOPPERS/JSP for Windows - VAG~[^
 */

#ifndef __HW_SERIAL_H
#define __HW_SERIAL_H

#include <s_services.h>

/*
 *  R[obN[`̎ʔԍ
 *  OPB_UARTLITE ́CM݂ĂȂ߁CӖ͂ȂD
 */
#define SIO_ERDY_SND    1u              /* M\R[obN */
#define SIO_ERDY_RCV    2u              /* MʒmR[obN */

	/* foCXJ̐ݒ */
#define SIO_MOD_MASK		0x80000000
#define SIO_MOD(x)			((x) & SIO_MOD_MASK)
#define SIO_MOD_SERVER		0x80000000
#define SIO_MOD_CLIENT		0x00000000

	/* foCX̎ */
#define SIO_TYP_MASK		0x000000ff
#define SIO_TYP(x)			((x) & SIO_TYP_MASK)
#define SIO_TYP_CONSOLE		0x00000001			/* EBhER\[  */
#define SIO_TYP_TTY			0x00000002			/* Windows̃R\[ */
#define SIO_TYP_SCRBUF		0x00000003			/* XN[obt@    */
#define SIO_TYP_RAWSIO		0x00000004			/* VA              */

	/* foCX̏ */
#define SIO_STA_MASK		0x0fff0000
#define SIO_STA(x)			((x) & SIO_STA_MASK)
#define SIO_STA_OPEN		0x00010000
#define SIO_STA_INTRCV		0x00020000
#define SIO_STA_INTSND		0x00040000

#define INHNO_SERIAL	3

#define TNUM_PORT		1

#ifndef _MACRO_ONLY

typedef struct serial_port_descriptor
{
	int					Flag;
	HANDLE				Handle;
	volatile int		ReceiveBuffer;
	void *				versatile;
	VP_INT              exinf;
} SIOPCB;

extern SIOPCB siopcb_table[TNUM_PORT];

/*
 *  SIOhCȍ[`
 */
extern void	sio_initialize(void);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB * sio_opn_por(ID siopid, VP_INT exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void	sio_cls_por(SIOPCB *siopcb);

/*
 *  VAI/O|[gւ̕M
 */
extern BOOL	sio_snd_chr(SIOPCB *siopcb, INT chr);

/*
 *  VAI/O|[gւ̕M
 */
extern INT	sio_rcv_chr(SIOPCB *siopcb);

/*
 *  SIO̊݃T[rX[`
 */
extern void	sio_isr(void);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void sio_ena_cbr(SIOPCB * siopcb, UINT cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void sio_dis_cbr(SIOPCB * siopcb, UINT cbrtn);

/*
 *  VAI/O|[gւ̕MR[obN
 */
extern void sio_ierdy_snd(VP_INT exinf);

/*
 *  VAI/O|[gւ̕MR[obN
 */
extern void sio_ierdy_rcv(VP_INT exinf);

/*
 *  VAI/O|[g̕MʒmR[obN
 */
extern void	sio_ercv_chr(ID siopid, INT chr);

/*
 *  VAI/O|[g݃nh
 */
extern void	sio_handler(void);

#endif

#endif

