/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: eventlog.c,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */


#include <s_services.h>

#ifdef EVENTLOG_ENABLE

#include "jsp_kernel.h"
#include "task.h"
#include "semaphore.h"
#include "dataqueue.h"
#include "eventflag.h"
#include "mempfix.h"
#include "mailbox.h"

//#include <kernel_debug.h>

extern SEMCB 	semcb_table[1];
extern UINT		tmax_semid;
extern FLGCB	flgcb_table[1];
extern UINT		tmax_flgid;
extern DTQCB 	dtqcb_table[1];
extern UINT		tmax_dtqid;
extern MBXCB 	mbxcb_table[1];
extern UINT		tmax_mbxid;
extern MPFCB 	mpfcb_table[1];
extern UINT		tmax_mpfid;

/*
 *  CxgOo͗p ^XNԎ擾֐
 *    (com_support.cC++ɂȂ̂ŁAɒu)
 */

Inline BOOL is_inside_of(void * src, void * min, void * sup)
{	return ((long)src >= (long)min) && ((long)src <  (long)sup);	}

static void decode_waitstatus(TCB * tcb, unsigned int * objtype, int * objid)
{
	QUEUE * queue;

	if((tcb->tstat & TS_WAIT_SLEEP) != 0)
	{
		*objtype = TTW_SLP;
	}else
	{
		if((tcb->tstat & TS_WAIT_WOBJCB) != 0)
		{
			do {
				queue = tcb->task_queue.next;
			} while( queue != &tcb->task_queue && is_inside_of(queue, tcb_table, &tcb_table[TNUM_TSK]) );

			if(queue == &tcb->task_queue)
				*objtype = 0;

				/* Z}tH */
			else if(is_inside_of(queue, semcb_table, &semcb_table[tmax_semid-1]))
			{
				*objtype = TTW_SEM;
				*objid   = ((long)queue - (long)semcb_table) / sizeof(SEMCB) + 1;
			}
				/* CxgtO */
			else if(is_inside_of(queue, flgcb_table, &flgcb_table[tmax_flgid-1]))
			{
				*objtype = TTW_FLG;
				*objid   = ((long)queue - (long)flgcb_table) / sizeof(FLGCB) + 1;
			}
				/* f[^L[ */
			else if(is_inside_of(queue, dtqcb_table, &dtqcb_table[tmax_dtqid-1]))
			{
				if(((long)queue % sizeof(DTQCB)) == (long)(&((DTQCB *)0)->rwait_queue))
					*objtype = TTW_RDTQ;
				else
					*objtype = TTW_SDTQ;
				*objid   = ((long)queue - (long)dtqcb_table) / sizeof(DTQCB) + 1;
			}
				/* [{bNX */
			else if(is_inside_of(queue, mbxcb_table, &mbxcb_table[tmax_mbxid-1]))
			{
				*objtype = TTW_MBX;
				*objid   = ((long)queue - (long)mbxcb_table) / sizeof(MBXCB) + 1;
			}
				/* Œ蒷v[ */
			else if(is_inside_of(queue, mpfcb_table, &mpfcb_table[tmax_mpfid-1]))
			{
				*objtype = TTW_MPL;
				*objid   = ((long)queue - (long)mpfcb_table) / sizeof(MPFCB) + 1;
			}
		}else
		{
				/* slp_tskł͂ȂAIuWFNg҂L[ɂȂĂȂ^CAEgt̑҂ -> dly_tsk */
			if(tcb->winfo->tmevtb != NULL)
				*objtype = TTW_DLY;
		}
	}
}

void decode_taskstatus(TCB * tcb, int * tskid, unsigned int * tskstat, unsigned int * objtype, int * objid)
{
	int stat = tcb->tstat;

		/* ^XNID */
	*tskid = TSKID(tcb);

		/* ^XN */
	*tskstat = TTS_DMT;
	if((stat & TS_RUNNABLE) != 0)
	{
		*tskstat = TTS_RDY;
	}else
	{
		if((stat & TS_WAITING) != 0)
		{
				/* ҂̃fR[h */
			decode_waitstatus((TCB *)tcb, objtype, objid);

			if((stat & TS_SUSPENDED) != 0)
				*tskstat = TTS_WAS;
			else
				*tskstat = TTS_WAI;
		}else
		{
			if((stat & TS_SUSPENDED) != 0)
				*tskstat = TTS_SUS;
		}
	}
}

#endif

