/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_context.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *	^XNReLXg샋[`
 *
 *  ̃t@C cpu_config.h ƕĂ̂́C̃t@C TCB
 *  `ꂽɓǂޕKv̂ɑ΂āCcpu_config.h ɂ TCB 
 *  `OɓǂޕKv`܂ł邽߂łD
 */

#ifndef _CPU_CONTEXT_H_
#define _CPU_CONTEXT_H_

#include "task.h"

/*
 *  ^XNReLXg̏
 *
 *  ^XNx~ԂɈڍs鎞i^XN̐C^XN̏IjɌ
 *  ΂D{Iɂ́C^XNReLXg^XNNłԂɐ
 *  肷鏈Ccreate_context  activate_context ōs΂悢D
 */
Inline void
create_context(TCB *tcb)
{
	tcb->tskctxb.ThreadID       = 0;
	tcb->tskctxb.InterruptLevel = 0;
}

/*
 *  ^XN̋N
 *
 *  ^XNx~ԂsłԂɈڍs鎞ɌĂ΂D
 */
extern DWORD WINAPI activate_r(LPVOID);

Inline void
activate_context(TCB *tcb)
{
	tcb->tskctxb.ThreadHandle = CreateThread(NULL,0,activate_r,(LPVOID)tcb,CREATE_SUSPENDED,&tcb->tskctxb.ThreadID);
    FatalAssertion(tcb->tskctxb.ThreadHandle != NULL, "activate_context could not create a thread");
}

/*
 *  ext_tsk X^bNɊmۂ_~[̈̃TCY
 */
#define	ACTIVATED_STACK_SIZE	0

#endif /* _CPU_CONTEXT_H_ */
