/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: com_support.cpp,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#include <vitron.h>
#include <com_support.h>
#include <eventlog.h>
#include "syslog.h"

#include <resource.h>

#include <commctrl.h>

/*
 *  Oɕꂽ̐
 *     Q: CX^CRgC++X^CRgĂ܂?
 *     A: CyɃRgAEgƍ鏈CX^CRgŁA悤ȏꏊ̐C++X^CRggĂ܂B
 *
 *     Q: ϐ̖ÂK߂Ⴍł?
 *     A: {IɃXR[v͈͂ŎgĂ܂B
 *          [J+"_", O[o啶, oJavaۂX^C
 *
 *     Q: INVALID_HANDLE_VALUE  NULL ǂgĂ̂ł?
 *     A: CreateXxxxsɕԋplł킹܂B
 *        ̓Iɂ́At@CINVALID_HANDLE_VALUE(CreateFile)ŁAȊONULLɂȂĂ܂B
 */

#ifndef __COM_NOT_REQUIRED__


//===================================================
/*
 *   ʕ
 */
extern "C" SYSTIM		_kernel_systim_offset;
extern "C" SYSTIM		_kernel_current_time;
extern "C" HINSTANCE	ProcessInstance;
extern "C" HANDLE		PrimaryDialogHandle;
extern "C" BOOL			ShutdownPostponementRequest;
extern "C" int          CPUStatus;

extern "C" void FatalAssertion(int exp, LPCSTR format, ... );

extern "C" void enter_system_critical_section(BOOL * cookie);
extern "C" void leave_system_critiacl_section(BOOL * cookie);

#ifdef KERNEL_DEBUG_MODE
   extern "C" _kernel_debugprintf(const char * format, ... );
#  define kprintf(x) _kernel_debugprintf x
#else
#  define kprintf(x)
#endif

//===================================================

	/* [U`̃O */
#define USERDEFINED	0x60
#define LOG_MODULENAME (0 | USERDEFINED)	/* W[̖O   */
#define LOG_TIMESTAMP  (1 | USERDEFINED)    /* L^Jn (SYSTEMTIME\̂̂܂܃_v) */

#define  __HAL_MSG_MSGONLY
#include <hal_msg.h>

#include <string>

namespace
{
	/*
	 *   COMC^[tF[X֘A̒`
	 */

		//XID̐錾
	const IID   IID_IKernelEvents = {0x1353969D,0xE84F,0x463F,{0xB2,0x11,0x33,0x7E,0x9B,0xCF,0xB9,0x9E}};
	const IID   IID_IKernel       = {0xD3E42099,0x3FDD,0x4A78,{0xBD,0xBD,0x4E,0x57,0xD3,0x62,0xF5,0xED}};
	const CLSID CLSID_Kernel      = {0x51789667,0x9F20,0x40AF,{0xAF,0x7F,0x98,0x56,0x32,0x5D,0xFB,0x0B}};

		// IKernelC^[tF[X`
	class IKernel : public IUnknown
	{
	public:
		STDMETHOD(Read)(unsigned long address,unsigned long sz,char __RPC_FAR data[]) PURE;
		STDMETHOD(IsValid)(BOOL __RPC_FAR * valid) PURE;
		STDMETHOD(Write)(unsigned long address,unsigned long sz,char __RPC_FAR data[]) PURE;
		STDMETHOD(OnLogEvent)(long sz, unsigned char __RPC_FAR data[]) PURE;
	};

		// IKernelEventsC^tF[X`
	class IKernelEvents : public IUnknown
	{
	public:
		STDMETHOD(QueryInterface)(REFIID iid, void ** unk);
		STDMETHOD_(ULONG,AddRef)();
		STDMETHOD_(ULONG,Release)();
		STDMETHOD(OnInterruptRequest)(long inhno);

		IKernelEvents(void);

		long RefCount;
	};

	/*
	 *   IKernelEvents
	 */

	IKernelEvents::IKernelEvents(void) : RefCount(0)
	{}

    STDMETHODIMP IKernelEvents::QueryInterface(REFIID iid, void ** unk)
	{
		if( iid == IID_IKernelEvents || iid == IID_IUnknown )
		{
			*unk = this;
			::InterlockedIncrement(&RefCount);
			return S_OK;
		}

		return E_NOINTERFACE;
	}

	STDMETHODIMP_(ULONG) IKernelEvents::AddRef()
	{	return ::InterlockedIncrement(&RefCount);	}

	STDMETHODIMP_(ULONG) IKernelEvents::Release()
	{
		if( ::InterlockedDecrement(&RefCount) == 0)
			delete this;
		return RefCount;
	}

	STDMETHODIMP IKernelEvents::OnInterruptRequest(long inhno)
	{

		if(inhno < 0)
		{
			/* inhno < 0 ͓ȈӖ */

			/* inhno = -1 : keep-alive */
		}else
			::PostMessage((HWND)PrimaryDialogHandle,HALMSG_MESSAGE,HALMSG_INTERRUPT,(LPARAM)inhno);
		return S_OK;
	}
}

namespace {
	/*
	 *   COMʐMpƃXbhɊւ`
	 */

	HANDLE request_semaphore    = NULL;		//v҂Z}tH
	HANDLE worker_thread_handle = NULL;		//ƃXbh̃nh

	//==============================================================================

		//COMƃXbhɍ쓮Ă邩ۂ
	inline bool IsValid(void)
	{	return (request_semaphore != NULL) && (worker_thread_handle != NULL);	}

	//===================================================

		/*
		 *    Q: ǂăVXebNKvȂ?
		 *    A: OCxgL[CO邽߂Ɋe^XN/݃Xbh
		 *        -> VisualC++̃}`XbhpmۃCu͓ŃNeBJZNVIuWFNggĔr䂵Ă
		 *        -> TOPPERS/JSP Windows̃fBXpb`(ǗXbh)͗vƍĂXbh~߂ɂ
		 *        -> mۗp̃NeBJZNV܂SuspendThreadĂ܂AmۗvõXbhSĂbN
		 *        -> ǗXbhOo߂ɃƂɗ̂ŁAǗXbhbN
		 *        -> ǗXbhbNƁAŏSuspendThreadꂽcNXbhȂ
		 *        -> fbhbN
		 *    ⑫ : COMʐMƃXbhR\[ǗXbĥ悤ɊǗXbhSuspendThread̑ΏۂɂȂȂXbh̓bNȂĂ
		 */

	//===================================================

		/* ƃXbhɗ^f[^ێNX */
	class Request
	{
	public:
		enum tagRequestType
		{
			Confirmation = 0x00,	/* [JXbh̓mF (Z}tH) */
			
			DeviceRead   = 0x01,	/* foCXG~[V Ǐo */
			DeviceWrite  = 0x02,	/* foCXG~[V ݑ */

			EventLog     = 0x03,	/* CxgOo */

			QuitThread   = 0xff		/* ƃXbh̏I */
		};

	protected:
		bool                blocking;
		bool				allocated;
		enum tagRequestType type;
		unsigned long       address;		/* foCX : foCX̂AhX */
		unsigned long       size;			/*      : storagef[^̃TCY */
		HGLOBAL             storage;		/*      : f[^i[Ă̈̃AhX(nh) */
		int                 result;			/*      : ubLOs̕ԋpn */
		HANDLE              signalobject;	/*      : ubLOs̃Xbhnh */

		Request *           next;		/* L[ɂ邽߂̃N */

		static LONG      RequestCount;	//L[ɂȂĂ郊NGXg̐
		static Request * top;			//NGXgL[̐擪 (ƂÂNGXg)
		static Request * tail;			//NGXgL[̖ (ƂVNGXg)
		static CRITICAL_SECTION cs;		//rL[p댯̈IuWFNg

		void connect(void)
		{
				//vL[ɂȂ
			::EnterCriticalSection(&cs);
			next = NULL;
			if(tail != NULL)
				tail->next = this;
			tail = this;
			if(top == NULL)
				top = tail;
			::LeaveCriticalSection(&cs);

			::InterlockedIncrement(&RequestCount);
		}

	protected:
			//RXgN^
		Request(enum tagRequestType _type, bool _block, unsigned int _size = 0, void * _storage = NULL, unsigned long _address = 0)
            :   blocking(_block), allocated(false), type(_type), address(_address), 
                size(0), storage(NULL), result(-1), signalobject(NULL), next(NULL)
		{
			size    = _size;

			if(size != 0)
			{
					//̈悪w肳ĂȂꍇAIɊmۂ
				if(_storage != NULL)
					storage = static_cast<HGLOBAL>(_storage);
				else
					allocate(size, false);
			}
		}

	public:
			//fXgN^
		virtual ~Request(void)
		{

				//̈悪ImۂĂꍇAjs
			if(storage != NULL && allocated)
			{
				BOOL lock;

				enter_system_critical_section(&lock);
	            ::GlobalFree(storage);
				leave_system_critiacl_section(&lock);
			}
		}

		static void initialize(void)
		{
            kprintf(("Request::initialize()\n"));
			if(RequestCount == -1)
			{
				::InitializeCriticalSection(&cs);
				RequestCount = 0;
				top  = NULL;
				tail = NULL;
			}
		}

		static void finalize(void)
		{
            kprintf(("Request::finalize()\n"));
			if(RequestCount != -1)
			{
				while(top != NULL)
				{
					Request * target = top;
					top = top->next;
					delete target;
				}

				::DeleteCriticalSection(&cs);	
				RequestCount = -1;
			}
		}

			// VXebNȂŃJ
		inline void release(void)
		{
			if(storage != NULL && allocated)
			{
				::GlobalFree(storage);
				storage = 0;
			}
		}

		inline bool isBlockingRequest(void) const
		{	return blocking;	}

		inline enum tagRequestType getType(void) const
		{	return type;	}

		inline bool operator == (enum tagRequestType _type) const
		{	return type == _type;	}

		inline bool operator != (enum tagRequestType _type) const
		{	return !(operator ==(_type));	}

		inline void * getStorage(void)
		{	return reinterpret_cast<void *>(storage);	}

		inline unsigned long getAddress(void) const
		{	return address;   }

		inline unsigned long getSize(void) const
		{	return size;	}

		inline int getResult(void) const
		{	return result;	}

		static inline LONG getRequestCount(void)
		{	return RequestCount;	}

			//̈̊m
			//	_size   : KvƂ̈̃TCY
			//	realloc : eێ邩ۂ
		bool allocate(unsigned int _size, bool realloc = false)
		{
			unsigned long old_size;
			HGLOBAL       old_storage;
			BOOL          lock;

			FatalAssertion(type != Confirmation, "Request::allocate was performed with Confirmation Request Object.");

			old_size    = size;
			old_storage = storage;

			enter_system_critical_section(&lock);
			storage = ::GlobalAlloc(GMEM_FIXED, _size);

			FatalAssertion(storage != NULL, "Request::allocate failed to allocate a memory block.");

				//O̓e̕ێ ї̈j
			if(old_storage != NULL)
			{
				if(realloc)
					::CopyMemory(storage, old_storage, old_size);

				if(allocated)
					::GlobalFree(old_storage);
			}
			leave_system_critiacl_section(&lock);

			allocated = true;
			size = _size;

			return true;
		}

			//eێ܂܍ăAP[g
		inline bool reallocate(unsigned int _size)
		{	return allocate(_size, true);   }

			//ێ̈ɑ΂鏑
		inline void set(void * data, unsigned int sz, unsigned int offset = 0)
		{
			if(size < sz)
				reallocate(sz + offset);

			::CopyMemory(reinterpret_cast<char *>(storage) + offset, data, sz);
		}

			//ێ̈ɑ΂Ǎ
		inline bool get(void * data, unsigned int sz, unsigned int offset = 0)
		{
			if(size < sz + offset)
				return false;

			::CopyMemory(data, reinterpret_cast<char *>(storage) + offset, sz);
		}

			//ێ̈̔Cӂ̈ʒuɑ΂|C^擾
			//		offset : 擪̃oCgItZbg
		void * getptr(unsigned int offset = 0)
		{
			if(offset > size || storage == NULL)
				return NULL;

			return reinterpret_cast<void *>(reinterpret_cast<char *>(storage) + offset);
		}

			/*
			 *   RequestIuWFNgt@Ng
			 *     Q: ǂăt@NgKvȂ̂?
			 *     A: mۂCPUbNKv邽 (ڍׂ͏LCPUbN闝RQ)
			 */			
		static Request * Create(enum tagRequestType _type, bool _block, unsigned int _size = 0, void * _storage = NULL, unsigned long _address = 0)
		{
			Request * request;
			BOOL      lock;

			enter_system_critical_section(&lock);
			request = new Request(_type, _block, _size, _storage, _address);
			leave_system_critiacl_section(&lock);
		
			return request;
		}

		static Request * GetRequest(void)
		{
			Request * result;

			::EnterCriticalSection(&cs);
			result = top;
			if(top != NULL)
			{
				top = top->next;
				if(top == NULL)
					tail = NULL;
			}
			::LeaveCriticalSection(&cs);

			::InterlockedDecrement(&RequestCount);

			return result;
		}

		void Finalize(bool succeeded)
		{
			if(this != 0) {
				if(isBlockingRequest())
					signal(succeeded ? getSize() : -1);
				else
				{
					BOOL lock;

					enter_system_critical_section(&lock);
					delete this;
					leave_system_critiacl_section(&lock);
				}
			}
		}

        virtual void signal(int _result = 0)
		{
			result = _result;
			if(signalobject != NULL)
				::PostThreadMessage((DWORD)signalobject, WM_QUIT, 0, 0);
		}
				
			/*
			 *   Vv̔s
			 *     (̊֐gXbh : ǗXbh, ݃Xbh, ^XNXbh)
			 */
		virtual int invoke(void)
		{
			int  _result;
			BOOL lock;
			MSG  msg;

			_result = 0;

			if(!IsValid())
				return -1;

			enter_system_critical_section(&lock);

			connect();

				//v̎s҂
			if(blocking)
			{
				signalobject = (HANDLE)::GetCurrentThreadId();

					//VvƂʒm
				::ReleaseSemaphore(request_semaphore,1,NULL);
				leave_system_critiacl_section(&lock);

					//WM_QUITbZ[Wgē
				while(::GetMessage(&msg, 0, 0, 0) != 0)
					::DispatchMessage(&msg);

					//̃IuWFNgĵŃobNAbv
				_result = result;

					//L[͍͂ƃXbh
					//delete request́AmubLOȂƃXbhӔCAubLOȂ炱ł
                enter_system_critical_section(&lock);
				delete this;
                leave_system_critiacl_section(&lock);
			}else
			{
					//VvƂʒm
				::ReleaseSemaphore(request_semaphore,1,NULL);
				leave_system_critiacl_section(&lock);
			}

			return _result;
		}
	};

	class EventDumpRequest : public Request
	{
	protected:
		static HANDLE FileHandle;

		EventDumpRequest(enum tagRequestType _type, bool _block, unsigned int _size = 0, void * _storage = NULL, unsigned long _address = 0) : Request(_type, _block, _size, _storage, _address) 
		{}

	public:
		static void initialize(void)
		{
			SYSTEMTIME systim;
			DWORD      written;
			char       buffer[1024];
			char *     top;
			char *     work;

			::GetLocalTime(&systim);
			::wsprintf(buffer, "kernel-log-%04d%02d%02d-%02d%02d%02d.log", systim.wYear, systim.wMonth, systim.wDay, systim.wHour, systim.wMinute, systim.wSecond);
			FileHandle = ::CreateFile(buffer, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL|FILE_FLAG_SEQUENTIAL_SCAN, NULL);

            kprintf(("EventDumpRequest : initialize (filename = '%s')\n", buffer));

			T_RGLOG_HEADER log;
			
			log.logtype = LOG_TIMESTAMP;
			log.logtim  = 0;
			log.bufsz   = sizeof(SYSTEMTIME);
			log.valid   = 1;
			::WriteFile(FileHandle, &log, sizeof(log), &written, NULL);
			::WriteFile(FileHandle, &systim, sizeof(SYSTEMTIME), &written, NULL);

				/* W[o */
			::lstrcpyn(buffer, ::GetCommandLine(), 1023);
			top = buffer;
			buffer[1023] = '\x0';	//T[`pԕ

			if(*top == '"')
			{
				++ top;
				for(work = top; *work != '\x0' && *work != '"'; ++work);
			}
			else
				for(work = top; *work != '\x0' && *work != ' '; ++work);

			*work = '\x0';	//^[~l[g

			log.logtype = LOG_MODULENAME;
			log.logtim  = 0;
			log.bufsz   = work - top + 1;	//^[~l[^̕
			log.valid   = 1;
			::WriteFile(FileHandle, &log, sizeof(log), &written, NULL);
			::WriteFile(FileHandle, top, log.bufsz, &written, NULL);
		}

		static void finalize(void)
		{
            kprintf(("EventDumpRequest : finalize()\n"));

			if(FileHandle != INVALID_HANDLE_VALUE)      //CreateFile returns INVALID_HANDLE_VALUE if it failed
				::CloseHandle(FileHandle);
		}

		static EventDumpRequest * Create(enum tagRequestType _type, bool _block, unsigned int _size = 0, void * _storage = NULL, unsigned long _address = 0)
		{
			EventDumpRequest * request;
			BOOL      lock;

			enter_system_critical_section(&lock);
			request = new EventDumpRequest(_type, _block, _size, _storage, _address);
			leave_system_critiacl_section(&lock);
		
			return request;
		}

		virtual int invoke(void)
		{
			DWORD written;
			BOOL  lock;

			enter_system_critical_section(&lock);
			if(FileHandle != INVALID_HANDLE_VALUE)      //CreateFile return INVALID_HANDLE_VALUE, not NULL, if it failed its operatation.
				::WriteFile(FileHandle, storage, size, &written, NULL);
			delete this;
			leave_system_critiacl_section(&lock);

			return 0;
		}
	};

    class ExclusiveDeviceRequest : public Request
    {
    protected:
        static HANDLE blocker;
    public:

        static void initialize(void) throw()
        {
            kprintf(("ExclusiveDeviceRequest::initialize()\n"));

            if(blocker == NULL) {
                blocker = ::CreateEvent(NULL, FALSE, FALSE, NULL);
            }
        }

        static void finalize(void) throw()
        {
            kprintf(("ExclusiveDeviceRequest::finalize()\n"));

            if(blocker != NULL) {
                ::CloseHandle(blocker);
            }
        }

        virtual void signal(int _result = 0)
        {
            result = _result;
            ::SetEvent(blocker);
        }

        virtual int invoke(void)
        {
            int  _result = 0;
            BOOL lock;
            BOOL cpustate;

                //荞݂֎~
            if((cpustate = CPUStatus) == 0)
                dis_int(0);

            enter_system_critical_section(&lock);

                //vL[̐擪ɂȂ
            ::EnterCriticalSection(&cs);
            next = top;
            top = this;
            if(tail == NULL)
                tail = this;
            ::LeaveCriticalSection(&cs);
            ::InterlockedIncrement(&RequestCount);

            ::ReleaseSemaphore(request_semaphore, 1, NULL);
            leave_system_critiacl_section(&lock);

            if(blocking) {
                ::WaitForSingleObject(blocker, INFINITE);

                _result = result;

                enter_system_critical_section(&lock);
                delete this;
                leave_system_critiacl_section(&lock);
            }

            if(cpustate == 0)
                ena_int(0);

            return _result;
        }
    };

//	typedef class EventDumpRequest EventRequest;
	typedef class Request EventRequest;		//CxgOo͗vŎgp郊NGXg
//	typedef class Request DeviceRequest;	//foCXʐMvŎgp郊NGXg
	typedef class ExclusiveDeviceRequest DeviceRequest;	//foCXʐMvŎgp郊NGXg

	//==============================================================================

	LONG				Request::RequestCount = -1;	//L[ɂȂĂ郊NGXg̐
	Request *			Request::top  = NULL;		//NGXgL[̐擪 (ƂÂNGXg)
	Request *			Request::tail = NULL;		//NGXgL[̖ (ƂVNGXg)
	CRITICAL_SECTION	Request::cs;				//rL[p댯̈IuWFNg

	HANDLE              EventDumpRequest::FileHandle    = INVALID_HANDLE_VALUE;     //CreateFile uses INVALID_HANDLE_VALUE for identifying an invalid instance 
    HANDLE              ExclusiveDeviceRequest::blocker = NULL;

	//==============================================================================

		/*
		 *   ƃXbhgpƊ֐̒`
		 */

		//RlNV|Cgւ̐ڑ
	bool Advise(IUnknown * container, REFIID iid, IUnknown * sink, DWORD * cookie, IConnectionPoint ** p_cp = NULL)
	{
		IConnectionPointContainer * cp_container;
		IConnectionPoint * cp;

        if(container == 0 || sink == 0 || cookie == 0)
            return false;

		if(p_cp == 0)
			p_cp = &cp;

			//IUnknownC^tF[XIConnectionPointContainerփLXg
		container->QueryInterface(IID_IConnectionPointContainer, (void **)&cp_container);
		if(cp_container == 0)
			return false;

			//ConnectionPointContainervɍConnectionPointT
		cp_container->FindConnectionPoint(iid, p_cp);
		cp_container->Release();
		if(*p_cp == 0)
			return false;

			//RlNV|Cgڑ
		if(FAILED((*p_cp)->Advise(sink, cookie)))
			return false;

		if(p_cp == &cp)
			cp->Release();
		return true;
	}

	//==============================================================================
	
    /*
     *  PerformRequest : v̎s
     *     ԋpl : Cxgp(true) or ƃXbh~(false)
     */

    bool PerformRequest(IKernel * manager)
    {
        Request * request;
        bool succeeded;

			//L[烊NGXg𔲂
		request = Request::GetRequest();
		FatalAssertion(request != NULL,"");

			//Iv
		if(request->getType() == Request::QuitThread)
		{
			if(!request->isBlockingRequest())
			{
				BOOL lock;

				enter_system_critical_section(&lock);
				delete request;
				leave_system_critiacl_section(&lock);
			}
            return false;
		}

			//v̏
		switch(request->getType())
		{
		case Request::Confirmation:
			succeeded = true;
			break;

		case Request::DeviceRead:
			succeeded = SUCCEEDED(manager->Read(request->getAddress(), request->getSize(), reinterpret_cast<char *>(request->getStorage())));
			break;

		case Request::DeviceWrite:
			succeeded = SUCCEEDED(manager->Write(request->getAddress(), request->getSize(), reinterpret_cast<char *>(request->getStorage())));
			break;

		case Request::EventLog:
			succeeded = SUCCEEDED(manager->OnLogEvent(request->getSize(), reinterpret_cast<unsigned char *>(request->getStorage())));

				//Vbg_EȂ烍OS͂I܂ő҂Ă炤
			ShutdownPostponementRequest = TRUE;
			break;

		default:
			succeeded = false;
		}

        request->Finalize(succeeded);

        return true;
    }

		/*
		 *   COMʐMs߂̍ƃXbh {
		 */
	DWORD WINAPI WorkerThreadProcess(LPVOID _param)
	{
		IKernel * manager;
		IKernelEvents * sink;
		IConnectionPoint * cp;
		DWORD cookie;
		BOOL Success;

        kprintf(("WorkerThreadProcess : start\n"));

			/*  */
		::CoInitialize(NULL);

			// foCX}l[WƐڑ
		manager = 0;
		if(FAILED(::CoCreateInstance(CLSID_Kernel, NULL, CLSCTX_ALL, IID_IKernel, (void **)&manager)))
			goto _WorkerThreadProc_Cleanup;

		cp = 0;
        sink = new(std::nothrow) IKernelEvents;
		if(!Advise(manager, IID_IKernelEvents, sink, &cookie,&cp))
		{
            if(sink != 0)
    			delete sink;
			goto _WorkerThreadProc_Cleanup;
		}

			/* C[` */
		manager->IsValid(&Success);
		if(Success != 0)
		{
            MSG msg;
			DWORD work;
            bool  loop_flag = true;
			
			do {
                    /*
                     * OCOMƃbZ[WƂĔł邽߁AWaitForSingleObjectŃZ}tH҂ƊO̗vsłȂȂB
                     * ̂߁AMsgWaitFor...pAbZ[Włꍇ͂ɑΏł悤ɂB
                     */

                    /*
                     * cygwinQS_ALLPOSTMESSAGE`Ȃ̂ŁAőΏ
                     */
#ifndef QS_ALLPOSTMESSAGE
#define QS_ALLPOSTMESSAGE (0x0100)
#endif

                    //v҂
                work = ::MsgWaitForMultipleObjects(1, &request_semaphore, FALSE, INFINITE, QS_ALLPOSTMESSAGE);

                switch(work) {

                    //v̎s
                case WAIT_OBJECT_0:
                        loop_flag = PerformRequest(manager);
                        break;

                    //O̗v (݂Ȃ)
                case WAIT_OBJECT_0 + 1:
                        GetMessage(&msg, 0, 0, 0);
                        TranslateMessage(&msg);
                        DispatchMessage(&msg);
                        break;
                
                default:
                    loop_flag = false;
                }

			} while(loop_flag);
		}

			/*
			 * Finalize
			 */

		if(cp != 0)
		{
			cp->Unadvise(cookie);
			cp->Release();
			cp = 0;
			sink = 0;
		}

	_WorkerThreadProc_Cleanup:

        if(manager != 0)
			manager->Release();

		CloseHandle(worker_thread_handle);
		worker_thread_handle = NULL;
        manager = 0l;
		::CoUninitialize();

		/* L[ɂ (҂) */

		Request * request;
		while((request = Request::GetRequest()) != 0)
			request->Finalize(false);
		
        kprintf(("WorkerThreadProcess : exit\n"));

        return 0;
	}
}

//==============================================================================

/****************************************************
 *                                                  *
 * TOPPERS/JSP - WindowsV~[V        *
 *   COMpfoCXG~[V@\        *
 *                                                  *
 ****************************************************/

#ifdef DEVICE_ENABLE

extern "C"
int _cdecl DeviceRead(unsigned long address, unsigned long size, void * storage)
{
	if(!IsValid() || storage == NULL)
		return -1;

	return DeviceRequest::Create(Request::DeviceRead, true, size, storage, address)->invoke();
}

extern "C"
int _cdecl DeviceWrite(unsigned long address, unsigned long size, void * storage)
{
	if(!IsValid() || storage == NULL)
		return -1;

	return DeviceRequest::Create(Request::DeviceWrite, true, size, storage, address)->invoke();
}

#endif


/****************************************************
 *                                                  *
 * TOPPERS/JSP - WindowsV~[V        *
 *   COMpJ[lO擾@\                *
 *                                                  *
 ****************************************************/

#ifdef EVENTLOG_ENABLE

	/* dOo͖h~pZ}tH :  1𑫂ʂ1łƂAOo͂ł */
static LONG event_write_semaphore = 0;

void event_write(unsigned int logtype, unsigned int valid, UINT bufsz, ... )
{
	EventRequest * event_request;
	DBIFLOG * log;
	va_list   vl;

	if(IsValid() && TlsGetValue(TLS_LOGMASK) == 0)
	{
			// NGXg̈m
		event_request = EventRequest::Create(EventRequest::EventLog, false, sizeof(T_RGLOG_HEADER) + bufsz);
		log     = reinterpret_cast<DBIFLOG *>(event_request->getptr());

			// wb_
		log->header.logtype = logtype;
		log->header.logtim  = _kernel_systim_offset + _kernel_current_time;
		log->header.valid   = valid;
		log->header.bufsz   = bufsz;

			// {̂̊i[
		va_start(vl, bufsz);
		for(unsigned int i=0;i<bufsz/sizeof(int);i++)
			*((int *)&log->body + i) = va_arg(vl, int);

			// v̑t (Non-blocking)
		event_request->invoke();
	}
}

extern "C"
void event_write_svc_enter(int fncd, unsigned int params, ... )
{
	EventRequest * event_request;
	DBIFLOG *      log;
	va_list        vl;
	unsigned int   i;

	if(IsValid() && TlsGetValue(TLS_LOGMASK) == 0)
	{
			//̈m : mۂTCY̓p[^ (ĂяoAhXi[)
		event_request = EventRequest::Create(EventRequest::EventLog, false, sizeof(T_RGLOG_HEADER) + sizeof(T_RGLOG_SVC) + params * sizeof(VP_INT));	
		log     = reinterpret_cast<DBIFLOG *>(event_request->getptr());

			//pPbg
		log->header.logtype = LOG_TYPE_SVC;
		log->header.logtim  = _kernel_systim_offset + _kernel_current_time;
		log->header.valid   = 0x7fffffff >> (29 - params);
		log->header.bufsz   = (params+3) * sizeof(int);

		va_start(vl, params);

		log->body.svc.fncno  = fncd;
		log->body.svc.prmcnt = params;

			/* 񃋁[v͍̂ŌɌďoAhXςł邽 */
		for(i=0;i<params+1;i++)
			log->body.svc.prmary[i] = va_arg(vl, VP_INT);

		event_request->invoke();
	}
}

extern "C"
void event_write_svc_leave(int fncd, unsigned int ercd, unsigned int retaddr)
{
	EventRequest * event_request;
	DBIFLOG * log;

	if(IsValid() && TlsGetValue(TLS_LOGMASK) == 0)
	{
			//̈m : mۂTCY̓p[^(ԋpl݂̂Ȃ̂łP) (ĂяoAhXi[)
		event_request = EventRequest::Create(EventRequest::EventLog, false, sizeof(T_RGLOG_HEADER) + sizeof(T_RGLOG_SVC) + sizeof(VP_INT));
		log     = reinterpret_cast<DBIFLOG *>(event_request->getptr());

			//wb_
		log->header.logtype = LOG_TYPE_SVC|LOG_LEAVE;
		log->header.logtim  = _kernel_systim_offset + _kernel_current_time;
		log->header.valid   = 0x7;
		log->header.bufsz   = 4 * sizeof(int);

			//{fB
		log->body.svc.fncno     = fncd;
		log->body.svc.prmcnt    = 1;
		log->body.svc.prmary[0] = (VP_INT)ercd;
		log->body.svc.prmary[1] = (VP_INT)retaddr;

		event_request->invoke();
	}
}

extern "C" void decode_taskstatus(void * tcb, int * tskid, unsigned int * tskstat, unsigned int * objtype, int * objid);

extern "C" 
void event_write_tskstat(void * tcb)
{
	EventRequest * event_request;
	DBIFLOG * log;

	if(IsValid())	//̓J[lȂ̂TLS_LOGMASKĂ͂Ȃ
	{
			//̈m
		event_request = EventRequest::Create(EventRequest::EventLog, false, sizeof(T_RGLOG_HEADER) + sizeof(T_RGLOG_TSKSTAT));
		log     = reinterpret_cast<DBIFLOG *>(event_request->getptr());

		log->header.logtype = LOG_TYPE_TSKSTAT;
		log->header.logtim  = _kernel_systim_offset + _kernel_current_time;
		log->header.valid   = 0xf;
		log->header.bufsz   = 4 * sizeof(int);

		decode_taskstatus(tcb, &log->body.tskstat.tskid, &log->body.tskstat.tskstat, &log->body.tskstat.tskwait, &log->body.tskstat.wobjid);

		event_request->invoke();
	}
}

#endif


static BOOL CALLBACK NotifyDialogProc(HWND hDlg,UINT Msg,WPARAM wParam,LPARAM lParam)
{
	switch(Msg)
	{
	case WM_INITDIALOG:
		{
			LONG  count;
			HWND  hCtrl;
			
			hCtrl = ::GetDlgItem(hDlg, IDC_PROGRESS1);
			count = Request::getRequestCount();

			::SetWindowLong(hDlg, GWL_USERDATA, count);
			::SendMessage(hCtrl, PBM_SETRANGE32, 0, count);
			::SendMessage(hCtrl, PBM_SETPOS, count - Request::getRequestCount(), 0);

			::SetTimer(hDlg, 100, 200, NULL);
			break;
		}

	case WM_TIMER:
		if(wParam == 100)
		{
			LONG  count;
			HWND  hCtrl;

			hCtrl = ::GetDlgItem(hDlg, IDC_PROGRESS1);
			count = ::GetWindowLong(hDlg, GWL_USERDATA);

			::SendMessage(hCtrl, PBM_SETPOS, count - Request::getRequestCount(), 0);

			if(Request::getRequestCount() <= 0)
				::PostQuitMessage(0);
		}
		break;
	case WM_CLOSE:
		break;

	default:
		return FALSE;
	}
	return TRUE;
}

extern "C"
void _cdecl InitializeComSupportModule(void)
{
    kprintf(("InitializeComSupportModule()\n"));

	Request::initialize();
	DeviceRequest::initialize();
	EventRequest::initialize();


	request_semaphore = ::CreateSemaphore(0, 0, 65536, 0);
	FatalAssertion(request_semaphore != NULL, "Object Creation Error : request_semaphore");

	worker_thread_handle = ::CreateThread(0, 0, WorkerThreadProcess, 0, 0, 0);
	FatalAssertion(worker_thread_handle != NULL, "Object Creation Error : worker_thread");

	Request * request = Request::Create(Request::Confirmation, true);
	request->invoke();
}

extern "C"
void _cdecl FinalizeComSupportModule(void)
{
    kprintf(("FinalizeComSupportModule()\n"));

    if(IsValid())
	{
		HWND  hDlgitem;
		HWND  NotifyDialog;
		MSG   msg;

			//O܂肷ƃOfɎԂAvO\悤Ɍ̂
			//uOfĂ邩҂āvƌxoB
		NotifyDialog = ::CreateDialog(ProcessInstance, MAKEINTRESOURCE(QUITNOTICEDIALOG), NULL, NotifyDialogProc);
		hDlgitem     = ::GetDlgItem(NotifyDialog, IDC_NOTIFYMSG);
		::SetWindowText(hDlgitem, " ꐶJ[l̃CxgOoĂ̂ŁAI܂ŏ҂Ă");
		::ShowWindow(NotifyDialog, SW_NORMAL);

		Request * request = Request::Create(Request::QuitThread, false);
		request->invoke();

			//I_CAOp̃bZ[W|v

        if(NotifyDialog != NULL) {
            while(GetMessage(&msg, NULL, 0, 0) != 0) {
        	    TranslateMessage(&msg);
                DispatchMessage(&msg);
            }
        }

			//ƃXbhI܂őҋ@
		if(worker_thread_handle != NULL)
            ::WaitForSingleObject(worker_thread_handle, INFINITE);
		::CloseHandle(request_semaphore);
        request_semaphore = NULL;

		EventRequest::finalize();
		DeviceRequest::finalize();
		Request::finalize();

		::DestroyWindow(NotifyDialog);
	}
}


#else	// __COM_NOT_REQUIRED__

extern "C"
void _cdecl InitializeComSupportModule(void)
{}

extern "C"
void _cdecl FinalizeComSupportModule(void)
{}

#endif // __COM_NOT_REQUIRED__
