/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005 by Freelines CO.,Ltd
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.h,v 1.1 2008/06/17 00:04:50 suikan Exp $
 */

#include "sys_config.h"

/*
 *	vZbTˑW[iV850pj
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */

#include <cpu_rename.h>

/*
 *  chg_ipm/get_ipm T|[g邩ǂ̒`
 */
/*#define	SUPPORT_CHG_IPM*/

/*
 *  TCB ֘A̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */

/*
 *  TCB ̃tB[h̃rbg̒`
 */
#define	TBIT_TCB_PRIORITY	8	/* priority tB[h̃rbg */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */

#ifndef _MACRO_ONLY
/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	unsigned long sp;		/* X^bN|C^ */
	unsigned long psw;		/* vOXe[^X[h */
	FP	pc;					/* vOJE^ */
} CTXB;

/*
 *  ݃}XN색Cu
 *
 *  ݃}XNiintmaskj́CIPMiInterrupt Priority Maskj8rbg
 *  ɃVtĝłD
 */

BOOL sense_lock(void);

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  ݂̊݃}XN̓Ǐo
 */

Inline UB
current_intmask(void)
{
	return (UB)sense_lock();
}

/*
 *  ݃}XN̐ݒ
 */

Inline void
set_intmask(UB intmask)
{
	if (intmask) {
		asm("di");
	} else {
		asm("ei");
	}
}

/*
 *  CPUbNƂ̉i^XNReLXgpj
 */

#define t_lock_cpu		lock_cpu
#define i_lock_cpu		lock_cpu
#define t_unlock_cpu	unlock_cpu
#define i_unlock_cpu	unlock_cpu

Inline void
lock_cpu(void)
{	asm("di");	}

Inline void
unlock_cpu(void)
{	asm("ei");	}


/*
 *  ݃lXgJE^
 */

extern UW	intnest;

Inline BOOL
sense_context(void)
{
	return (intnest > 0);
}

/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	exit_and_dispatch(void);

/*
 *  ݃nh^CPUOnh̐ݒ
 */

typedef struct int_vector_entry {
	FP	inthdr;
} INTVE;

extern INTVE InterruptHandlerEntry[NUM_INTERRUPT];

/*
 *  OxN^e[u̍\̒`
 */
typedef struct exc_vector_entry {
	FP	exchdr;			/* Onh̋NԒn */
} EXCVE;

/*
 *  ݃nh̐ݒ
 *
 *  xNgԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 */
Inline void
define_inh(INHNO inhno, FP inthdr)
{
	InterruptHandlerEntry[inhno-1].inthdr = inthdr;
}

/*
 *  CPUOnh̐ݒ
 *
 *  xNgԍ excno CPUOnh̋NԒn exchdr ɐݒ肷D
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
	define_inh(excno, exchdr);
}

/*
 *  ݃nh^CPUOnh̏o
 */


/*
 *  ݃nh̏o̐}N
 *
 *  reqflg `FbNOɊ݂֎~ȂƁCreqflg `FbN
 *  ɋNꂽ݃nhŃfBXpb`vꂽꍇɁCfB
 *  Xpb`ȂD
 */


#define INT_ENTRY(hdr) hdr
#define INTHDR_ENTRY(entry)	extern void entry();

/*
 *  CPUOnh̏o̐}N
 *
 *  CPUOnh́C^XNReLXgŎsD̂߁CCPU
 *  OnhĂяoOɊ݃[hɈڍsC^[Ă
 *  ̃[hɖ߂D̃[hɖ߂߂ɁC݃[hɈڍsO
 *   SR ݃X^bNɕۑDCPUO^XNReLXg
 *  Creqflg  TRUE ɂȂɁCret_exc ֕򂷂D
 *  reqflg `FbNOɊ݂֎~ȂƁCreqflg `FbN
 *  ɋNꂽ݃nhŃfBXpb`vꂽꍇɁCfB
 *  Xpb`ȂD
 */

#define EXC_ENTRY(hdr) hdr
#define EXCHDR_ENTRY(entry)	extern void entry();

/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃fBXpb`
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	/* PƔr̂́AݎsCPUO̕ 		*/
	/*  ݃lXgJE^CNgĂ邽 	*/
	return(intnest > 0);
}

/*
 *  CPUO̔CPUbNԂ̎Q
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return((*((UH *) p_excinf) & 0x0700) == 0x0700);
}

/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
