; *
; *  TOPPERS/JSP Kernel
; *      Toyohashi Open Platform for Embedded Real-Time Systems/
; *      Just Standard Profile Kernel
; * 
; *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
; *                              Toyohashi Univ. of Technology, JAPAN
; * 
; *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
; *  ɂČ\Ă GNU General Public License  Version 2 ɋL
; *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
; *  ς̂܂ށDȉjgpEEρEĔzziȉC
; *  pƌĂԁj邱Ƃ𖳏ŋD
; *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
; *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
; *      XR[hɊ܂܂Ă邱ƁD
; *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
; *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
; *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
; *      ̖ۏ؋Kfڂ邱ƁD
; *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
; *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
; *      ƁD
; *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
; *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
; *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
; *        񍐂邱ƁD
; *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
; *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
; * 
; *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
; *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
; *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
; *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
; * 
; *  @(#) $Id: cpu_support.S,v 1.1 2008/06/17 00:04:35 suikan Exp $
; *

        .c_mode
        .align  1
        .global __kernel_dispatch
        .include  "c5402dsk.h"
        .mmregs

__kernel_dispatch:
        PSHM   AR1                       ;AR1,6,7X^bNɕۑ
        PSHM   AR6                       ;PC͌ĂяoɃX^bNɕۑ
        PSHM   AR7                       ;̕⏕WX^ARx͕ۑKv͂Ȃ
        LDM    SP,A
        MVDM   *(__kernel_runtsk),AR1    ;AR1 <- runtsk
        NOP
        STL    A,*AR1(TCB_sp)            ;^XNX^bNTCBɕۑ
        ST     #dispatch_r,*AR1(TCB_pc)  ;sĊJԒnTCBɕۑ
        B      dispatcher_1

dispatch_r:
        POPM   AR7                       ;WX^𕜋A
        POPM   AR6
        POPM   AR1 
        B      __kernel_calltex          ;^XNO[`̌Ăяo

        .global __kernel_exit_and_dispatch
__kernel_exit_and_dispatch:
        SSBX   INTM                      ;荞݋֎~
        ST     #0,*(__kernel_nest)               ;J[l̏̂
dispatcher_1:
        LD     *(__kernel_schedtsk),A    ;schedtsk邩H
        BC     dispatcher_2,AEQ          ;΃Wv
        MVDK   *(__kernel_schedtsk),*(__kernel_runtsk)   ;schedtskruntsk
        MVDM   *(__kernel_runtsk),AR1
        NOP
        MVDK   *AR1(TCB_sp),SP           ;TCBX^bN𕜋A
        LD     *AR1(TCB_pc),A            ;TCBsĊJԒn𕜋A
        BACC   A    
        
dispatcher_2:
        STM    #STACKTOP,SP
        ST     #0x01,*(__kernel_nest)
        RSBX   INTM                      ;荞݋
        IDLE   1                         ;Zbg}XNĂȂݑ҂
        SSBX   INTM                      ;荞݋֎~
        ST     #0x0,*(__kernel_nest)
        B      dispatcher_1


;
;  ^XN̋N
;

        .global __kernel_activate_r
;         .global _activate_r
__kernel_activate_r:
;_activate_r:
        RSBX   INTM                      ;荞݋
        POPM   AR2
        POPM   AR3
        LDM    AR2,B
        LDM    AR3,A
        BACC   B



        .global _interrupt
_interrupt:
        PSHM   ST0
        PSHM   AL
        PSHM   AH
        PSHM   AG
        PSHM   BL
        PSHM   BH
        PSHM   BG
        PSHM   ST1
        PSHM   AR0
        PSHM   AR2
        PSHM   AR3
        PSHM   AR4
        PSHM   AR5
        PSHM   T
        PSHM   TRN
        PSHM   BK
        PSHM   BRC
        PSHM   RSA
        PSHM   REA
        PSHM   PMST
        LD     *(__kernel_nest),A
        ADDM   #1,*(__kernel_nest)               ;荞݂̃lXg񐔂CNg
        BC     _interrupt_from_int,ANEQ
        LDM    SP,A                      ;X^bNւ
        STM    #STACKTOP,SP              ;̃X^bN|C^
        PSHM   AL                        ;ۑs
        PSHM   IMR
        MVDM   *(_INT_VECNO),AR2         ;ItZbglAR2ɃZbg
        STM    #IMR,AR3                  ;荞݂xȂ悤
        LD     *AR2(__kernel_int_mask_table),A   ;            b
        AND    *AR3,A                    ;            
        STL    A,*AR3                    ;݂̊荞݂}XN 
        LD     *AR2(__kernel_int_table),A        ;荞݃nh̃AhX擾
        RSBX   INTM                      ;ȍ~荞݂󂯎󂯕t
        CALA   A                         ;荞݃nh
        SSBX   INTM                      ;荞݂֎~
        ADDM   #-1,*(__kernel_nest)              ;fNg
        POPM   IMR
        POPM   SP                        ;߂悪^XNȂ̂ŃX^bN߂
        LD     *(__kernel_reqflg),A
        BC     _ret_to_task_int,AEQ      ;reqflgFALSEȂWv
        ST     #0,*(__kernel_reqflg)
        B      ret_int

_interrupt_from_int:
        LDM    SP,A
        ANDM   #0xFFFE,*(SP)
        NOP
        NOP
        PSHM   AL
        PSHM   IMR
        MVDM   *(_INT_VECNO),AR2         ;ItZbglAR2ɃZbg
        STM    #IMR,AR3                  ;荞݂xȂ悤
        LD     *AR2(__kernel_int_mask_table),A   ;            b
        AND    *AR3,A                    ;            
        STL    A,*AR3                    ;݂̊荞݂}XN 
        LD     *AR2(__kernel_int_table),A        ;荞݃nh̃AhX擾
        RSBX   INTM                      ;ȍ~荞݂󂯕t
        CALA   A                         ;荞݃nhw
        SSBX   INTM                      ;荞݋֎~
        POPM   IMR
        POPM   SP
        ADDM   #-1,*(__kernel_nest)              ;荞݂̃lXg񐔂fNg
_ret_to_task_int:                        ;WX^𕜋A荞݌֖߂B
        POPM   PMST
        POPM   REA
        POPM   RSA
        POPM   BRC
        POPM   BK
        POPM   TRN
        POPM   T
        POPM   AR5
        POPM   AR4
        POPM   AR3
        POPM   AR2
        POPM   AR0
        POPM   ST1
        POPM   BG
        POPM   BH
        POPM   BL
        POPM   AG
        POPM   AH
        POPM   AL
        POPM   ST0
        RETE
        
        .global ret_int
ret_int:
        LD     *(__kernel_enadsp),A
        BC     ret_int_1,AEQ
        MVDM    *(__kernel_runtsk),AR0
        MVDM    *(__kernel_schedtsk),AR2
        NOP
        CMPR   EQ,AR2                    ;runtskschedtskr 
        BC     ret_int_1,TC
        PSHM   AR1
        PSHM   AR6
        PSHM   AR7
        LDM    SP,A
        STL    A,*AR0(TCB_sp)
        ST     #ret_int_r,*AR0(TCB_pc)
        B      dispatcher_1
ret_int_r:
        POPM   AR7
        POPM   AR6
        POPM   AR1
ret_int_1:
        LDM    SP,A
        ANDM   #0xFFFE,*(SP)
        NOP
        NOP
        PSHM   AL
        FRAME  #-1
        LD     #__kernel_calltex,A
        CALA   A
        FRAME  #1
        POPM   SP
        NOP
        POPM   PMST
        POPM   REA
        POPM   RSA
        POPM   BRC
        POPM   BK
        POPM   TRN
        POPM   T
        POPM   AR5
        POPM   AR4
        POPM   AR3
        POPM   AR2
        POPM   AR0
        POPM   ST1
        POPM   BG
        POPM   BH
        POPM   BL
        POPM   AG
        POPM   AH
        POPM   AL
        POPM   ST0
        RETE

;
;   ԑ҂
;
        .global	_sil_dly_nse
_sil_dly_nse:
        SSBX      SXM
        NOP
        LD	*(AL), A
        SUB	#SIL_DLY_TIM1, A, A
        BC	_sil_dly_nse1, AGT
        RET
_sil_dly_nse1:
        SUB	#SIL_DLY_TIM2, A, A
        BC	_sil_dly_nse1, AGT
        RET

