/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: tl16c550cfn.c,v 1.1 2008/06/17 00:04:46 suikan Exp $
 */

/*
 * TL16c550cfn phCo
 */

#include <s_services.h>
#include "tl16c550cfn.h"

/*
 * J[lNp̏(sys_putcgp邽)
 */
void
uart_init(void)
{
	/*  FIFOLɂAMMFIFONAA
	 *  gKxP(MMʁj
	 *  8f[^A1XgbvrbgAno parity 
	 */ 
	UART_FCR = (FCR_FIFO | FCR_RFRST | FCR_TFRST | FIFO_TRIG);
	UART_LCR = 0x03;
	 /*  {[[gWX^ɃANZX */
	UART_LCR |= LCR_DLAB;
	UART_DLL = UART_BAUD_RATE;
	UART_DLM = UART_BAUD_RATE >> 8;
	/*  BAUD RATEݒI  */
	UART_LCR &= ~LCR_DLAB;
	UART_SCR = UART_LSR;
}

/*
 *  VAI/O|[gubN
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {0};

/*
 *  VAI/O|[gǗubÑGA
 */
SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  MH
 */
Inline BOOL
uart_getready(SIOPCB *siopcb)
{
	return((UART_LSR & LSR_DR) != 0);
}

/*
 *  𑗐Mł邩H
 */
Inline BOOL
uart_putready(SIOPCB *siopcb)
{
	return((UART_LSR & LSR_THRE) != 0);
}

/*
 *  M̎o
 */
Inline char
uart_getchar(SIOPCB *siopcb)
{
	return((char) UART_RBR);
}

/*
 *  M镶̏
 */
Inline void
uart_putchar(SIOPCB *siopcb, char c)
{
	UART_THR = (UB) c;
}

/*
 *  M݋
 */
Inline void
uart_enable_send(SIOPCB *siopcb)
{
	UART_IER |= IER_TIE;
}

/*
 *  M݋֎~
 */
Inline void
uart_disable_send(SIOPCB *siopcb)
{
	UART_IER &= ~IER_TIE;
}

/*
 *  M݋
 */
Inline void
uart_enable_rcv(SIOPCB *siopcb)
{
	UART_IER = IER_RIE;
}

/*
 *  M݋֎~
 */
Inline void
uart_disable_rcv(SIOPCB *siopcb)
{
	UART_IER &= ~IER_RIE;
}

/*
 *  SIOhCȍ[`
 */
void
uart_initialize()
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->openflag = FALSE;
	}
}

/*
 * I[vĂ|[g邩
 */
BOOL
uart_openflag(void)
{
	return(siopcb_table[0].openflag);
}



/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
uart_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;

	siopcb = get_siopcb(siopid);
	
	/*  FIFOLɂAMMFIFONAA
	 *  gKxP(MMʁj
	 *  8f[^A1XgbvrbgAno parity 
	 */
	UART_FCR = (FCR_FIFO | FCR_RFRST | FCR_TFRST | FIFO_TRIG);
	UART_LCR = 0x03;
	/*  {[[gWX^ɃANZX */
	UART_LCR |= LCR_DLAB;
	UART_DLL = UART_BAUD_RATE;
	UART_DLM = UART_BAUD_RATE >> 8;
	/*  BAUD RATEݒI  */
	UART_LCR &= ~LCR_DLAB;
	/*  G[tONA  */
	UART_SCR = UART_LSR;
	UART_IER = IER_RIE;       /*  M荞݋  */
	
	siopcb->exinf = exinf;
	siopcb->openflag = TRUE;
	siopcb->getready = siopcb->putready = FALSE;

	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
uart_cls_por(SIOPCB *siopcb)
{
	/* MM荞ݗv֎~ */
	UART_IER = 0;
	
	siopcb->openflag = FALSE;
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, char chr)
{
	if (uart_putready(siopcb)) {
		uart_putchar(siopcb, chr);
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
	if (uart_getready(siopcb)) {
		return((INT)(UB) uart_getchar(siopcb));
	}
	return(-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	    case SIO_ERDY_SND:
		uart_enable_send(siopcb);
		break;
	    case SIO_ERDY_RCV:
		uart_enable_rcv(siopcb);
		break;
	}
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	    case SIO_ERDY_SND:
		uart_disable_send(siopcb);
		break;
	    case SIO_ERDY_RCV:
		uart_disable_rcv(siopcb);
		break;
	}
}

/*
 *  VAI/O|[gɑ΂銄ݏ
 */
static void
uart_isr_siop(SIOPCB *siopcb)
{
	if (uart_getready(siopcb)) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		uart_ierdy_rcv(siopcb->exinf);
	}
	if (uart_putready(siopcb)) {
		/*
		 *  M\R[obN[`ĂяoD
		 */
		uart_ierdy_snd(siopcb->exinf);
	}
}

/*
 *  SIO̊݃T[rX[`
 */
void
uart_isr()
{
	if (siopcb_table[0].openflag) {
		uart_isr_siop(&(siopcb_table[0]));
	}
}
