;
;   TOPPERS/JSP Kernel
;       Toyohashi Open Platform for Embedded Real-Time Systems/
;       Just Standard Profile Kernel
;
;   Copyright (C) 2006 by Witz Corporation, JAPAN
;
;   L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
;   ɂČ\Ă GNU General Public License  Version 2 ɋL
;   qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
;   ς̂܂ށDȉjgpEEρEĔzziȉC
;   pƌĂԁj邱Ƃ𖳏ŋD
;   (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
;       \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
;       XR[hɊ܂܂Ă邱ƁD
;   (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
;       pł`ōĔzzꍇɂ́CĔzzɔhLgip
;       ҃}jAȂǁjɁCL̒쌠\C̗pщL
;       ̖ۏ؋Kfڂ邱ƁD
;   (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
;       płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
;       ƁD
;     (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
;         쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
;     (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
;         񍐂邱ƁD
;   (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
;       QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
;
;   {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
;   TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
;   ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
;   ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
;
;   @(#) $Id: cpu_support.app,v 1.1 2006/04/10 08:19:25 honda Exp $
;

	$MAXIMUM
	module cpu_support_app

;
;	vZbTˑW[ AZuꕔiTLCS-900L1pj
;

#define	SUPPORT_CHG_IPM
#include "jsp_rename.h"
#include "cpu_rename.h"
#include "sys_rename.h"
#include "offset.inc"

; OQƃV{`
	extern large	__StackTop
	extern large	_reqflg
	extern large	_enadsp
	extern large	_intcnt
	extern large	_runtsk
	extern large	_schedtsk
	extern large	_call_texrtn
	extern large	_task_intmask


f_code section code large align=1,1

;
;	^XNfBXpb`
;
;   dispatch ́C^XNReLXgԁE݋֎~ԂŌĂяoȂ
;   ΂ȂȂDexit_and_dispatch C^XNReLXgԁE
;   ݋֎~ԂŌĂяôł邪CJ[lNɑΉ邽߁C
;   ݃ReLXgԂŌĂяoꍇɂΉĂD
;	Ăяo: SRIFF=7 (݋֎~),
;				  intcnt = 0(^XNReLXg), ^XNX^bN
;
	public _dispatch

_dispatch:
	push	xiz			; ֐ďoŕی삪KvȃWX^̕ۑ
	ld		xwa, (_runtsk)	; 쒆^XNTCB擾
	ld		(xwa+TCB_sp), xsp	;
	lda		xhl, dispatch_r	;
	ld		(xwa+TCB_pc), xhl	;
	jr		dispatcher	;

;
;	Ăяo: SRIFF=7 (݋֎~),
;				  intcnt = 0(^XNReLXg), ^XNX^bN
;
;	xwa ɂruntsk ̃AhXi[Ă
;
dispatch_r:
	pop		xiz		;
	ld		bc, (xwa+TCB_enatex)	;
	bit		TCB_enatex_bit, bc	;
	jr		z, dispatch_r_1	; enatex  FALSE Ȃ烊^[
	cpw		(xwa+TCB_texptn), 0	; ^XNOvꍇ
	jp		nz, _call_texrtn	;
	; call_texrtn璼dispatch Ăяo֖߂.
dispatch_r_1:				; ^XNOsȂꍇ
	ret				; dispatch Ăяo֖߂.

;
;	^XNN
;
;	ł, CPUbNԂɂ, ^XNN.
;
;	Ăяo: SRIFF=7 (݋֎~),
;				  intcnt = 0(^XNReLXg), ^XNX^bN
;
	public _activate_r

_activate_r:
	pop		xhl		; ^XN̋NԒnwhl ɐݒ
#ifdef SUPPORT_CHG_IPM			/* t_unlock_cpu ̏ */
	push	sr			; ݃}XN task_intmask ݒ
	ld		wa, (_task_intmask)	;
	andw	(xsp), ~0x7000	;
	or		(xsp), wa	;
	pop		sr			;
#else /* SUPPORT_CHG_IPM */
	ei		0		; ݋
#endif /* SUPPORT_CHG_IPM */
	jp		xhl

;
;	dispatcherĂяo:
;		EׂẴ^XÑReLXg͕ۑĂ.
;		ESRIFF=7 (݋֎~)
;		EReLXg̓^XNReLXg(intcnt=0)
;	dispatcher ďõX^bN:
;		dispatch 炫ꍇ: ^XNX^bN
;		exit_and_dispatch 炫ꍇ: 
;			exit_task 炫ꍇ̓^XNX^bN
;			J[lN͊݃X^bN
;		ret_int 炫ꍇ: ^XNX^bN
;		dispatcher_2 ł̊ݑ҂炫ꍇ: ݃X^bN
;
	public _exit_and_dispatch

_exit_and_dispatch:
	ldw		(_intcnt), 0	; lXgJE^NA(^XNReLXg)
dispatcher:
	ld		xwa, (_schedtsk)	; schedtsk  runtsk ɐݒ
	ld		(_runtsk), xwa	;
	or		xwa, xwa		; s^XN΃ACh[v
	jr		z, pre_idle_loop	;
	ld		xsp, (xwa+TCB_sp)	; ^XNX^bN|C^𕜋A
	ld		xhl, (xwa+TCB_pc)	;
	jp		xhl			; sĊJԒnփWv
;
;	sׂ^XN܂ő҂
;
pre_idle_loop:
	ld		xsp, __StackTop ; ݗp̃X^bN֐ؑւ
	incw	1, (_intcnt)	; ^XNReLXg
;
;	Ŕ^XNReLXg,݃X^bNɐ؂芷̂,
;	Ŕ銄ݏɂǂ̃X^bNgƂ̉,
;	݃nhł̃fBXpb`h~Ƃ2̈ӖD
;
idle_loop:
#ifdef SUPPORT_CHG_IPM			/* t_unlock_cpu ̏ */
	push	sr			; ݃}XN task_intmask ݒ
	ld		wa, (_task_intmask)	;
	andw	(xsp), ~0x7000	;
	or		(xsp), wa	;
	pop		sr			;
#else /* SUPPORT_CHG_IPM */
	ei		0		; ݋
#endif /* SUPPORT_CHG_IPM */

	halt 		; IDLE2Ԃ֑J
	nop			; LhaltRg(nop̂)ɂ
	nop			; sȂACh[vƂȂ.
	nop			; 
	nop			; 
	ei		7			; ݋֎~
	cpw		(_reqflg), 0	; reqflg  FALSE ł
	jr		z, idle_loop	;         idle_loop 
	ldw		(_reqflg), 0	; reqflg <--- FALSE
	decw		1, (_intcnt)	; ^XNReLXgɖ߂
	jr		dispatcher		; dispatcher ֖߂

;
;  xfBXpb`
;
;	Ăяo: SRIFF=7 (݋֎~),
;				  intcnt = 0(^XNReLXg), ^XNX^bN
;				  reqflg = TRUE
;				  INTNESTWX^ = 1
;
ret_int:
	ldw		(_reqflg), 0	; reqflg <--- FALSE
	ld		de, 0	;
	ldc		intnest, de	; fBXpb`intnest 0
	push	xiz			; ֐ďoŕی삪KvȃWX^̕ۑ
	ld		xwa, (_runtsk)	; runtsk 擾
	cpw		(_enadsp), 0	; enadsp  FALSE Ȃ
	jr		z, ret_int_r	; ret_int_r 
	cp		xwa, (_schedtsk)	; runtsk schedtsk Ȃ
	jr		z, ret_int_r	; ret_int_r 
	or		xwa, xwa	; runtsk = NULL Ȃ
	jr		z, dispatcher	; ۑdispather 
	ld		(xwa+TCB_sp), xsp	;
	lda		xhl, ret_int_r	;
	ld		(xwa+TCB_pc), xhl	;
	jr		dispatcher	;

;
;	Ăяo: SRIFF=7 (݋֎~),
;				  intcnt = 0(^XNReLXg), ^XNX^bN
;				  INTNESTWX^ = 0
;
;	xwa ɂruntsk ̃AhXi[Ă
;
ret_int_r:
	pop		xiz
#ifdef SUPPORT_CHG_IPM		/* X^bNɂSR IFF 𑀍 */
	ld		de, (_task_intmask)	;
	andw	(xsp+24), ~0x7000	;
	or		(xsp+24), de	;
#endif /* SUPPORT_CHG_IPM */
	ld		bc, (xwa+TCB_enatex)	;
	bit		TCB_enatex_bit, bc	;
	jr		z, nest_ctrl_r	; enatex  FALSE Ȃ烊^[
	cpw		(xwa+TCB_texptn), 0	; ^XNOvꍇ
	call	nz, _call_texrtn	;
nest_ctrl_r:
	ld		de, 1	;
	ldc		intnest, de	; retipɋ[Iintnest 1
	jr		interrupt_r

;
;	/CPUŐʏ
;
;	ďo:
;	ESRIFF=7.
;	EX^bN͑d荞݂Ȃ犄݃X^bN, łȂ
;	  ^XNX^bN
;	EXHL ɂ͊/CPUOnh̃AhXi[Ă.
;	EAW ɂ͖{݂̗Dxݒ肳ꂽ SR i[Ă.
;
;	WX^X^bNɂǂ̂悤ɕۑĂ邩ȉɎ.
;	̐}ł͏オ, ʂ̃AhX, X^bN͉
;	ɌĐςݏグ̂Ƃ.
;
;	--------------------------------------
;	|        CPUOnḧ       |
;	|          CPUO(4byte)        |
;	|                                    |
;	|                                    |
;	--------------------------------------
;	|             XSP(4byte)             | ^XNX^bN|C^D
;	|             î             | i݂̊̂ݕێD
;	|                                    |
;	|                                    |
;	--------------------------------------
;	|             XIY(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	--------------------------------------
;	|             XIX(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	--------------------------------------
;	|             XDE(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	--------------------------------------
;	|             XBC(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	-------------------------------------- <-- ݓŏD
;	|             XHL(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	--------------------------------------
;	|             XAW(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	-------------------------------------- <-- ݔɃn[hEFA
;	|              SR(2byte)             |     ɂďD p_excinf
;	|                                    |     w悤ɉZD
;	--------------------------------------
;	|              PC(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	--------------------------------------
;
;	nh烊^[, d݂łȂ,  reqflg 
;	TRUE ɂȂɁCret_int ֕򂷂D
;
;	d݂ǂ͊݃lXgJE^̒lŔ肷.
;	intcnt != 0 ȂΑd݂łƔ肷.
;	ȂCn[hEFAdlCݔ犄݋֎~s܂ł̊Ԃ
;	d݂ƁCd݂ł邱Ƃ\tgEFAŌm
;	Ȃ߁CŏɔݏsȂ܂܃^XNfBX
;	pb`\D̑d݂m邽߂Ƀn[hEFA
;	INTNEST WX^𗘗pD
;
;	reqflg CPUbNԂŃ`FbN. łȂƁC
;	reqflg `FbNɋNꂽ݃nh
;	fBXpb`vꂽꍇɁCfBXpb`Ȃ.
;
	public _interrupt

_interrupt:
	push	xbc			; XNb`WX^̎cۑ
	push	xde			;
	push	xix			;
	push	xiy			;

	ld		xbc, xsp	; CPUOɎgp邽߂Ŏ擾
	cpw		(_intcnt), 0	;
	jr		nz, from_int	;
	ld		xsp, __StackTop ; i݂̊̏ꍇX^bN؂ւ
	push	xbc			; ^XNSP̕ێ
from_int:				;
	incw	1, (_intcnt)	; ݃lXgJEgCNg

	add		xbc, 24	; CPUO
	push	xbc			; ݏł͖gp
	push	wa			;
	pop		sr			; {݂Dx̍݋
	call	xhl			; ݃nh/CPUOĂяo
	ei		7			; ݋֎~
	pop		xbc			; X^bN킹(CPUO)

	decw	1, (_intcnt)	; ݃lXgJEgfNg
	jr		nz, from_int_r	;
	pop		xbc			; i݂̊̏ꍇ^XNSP̕A
	ld		xsp, xbc	;
	ldc		de, intnest	; ݔ犄݋֎~܂ł̊Ԃɑd݂
	djnz	de, from_int_r	; Ăꍇ̓fBXpb`Ȃ
	cpw		(_reqflg), 0	; reqflg  TRUE ł
	jp		nz, ret_int	;              ret_int 
from_int_r:		;
interrupt_r:	;
	pop		xiy	;XNb`WX^𕜋A
	pop		xix	;
	pop		xde	;
	pop		xbc	;
	pop		xhl	;
	pop		xwa	;
	reti	;

;
; gp݂̏
;
	public unused_interrupt

unused_interrupt:
	reti


	end


