/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2006 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_insn.h,v 1.1 2008/06/17 00:04:50 suikan Exp $
 */

/*
 *	vZbT̓ꖽ߂̃CC֐`iTLCS-900L1pj
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/*
 *  Xe[^XWX^iSRǰݒl̓Ǐo
 */
#pragma inline current_sr
UH
current_sr()
{
	Asm("	push	sr");
	Asm("	pop		hl");
	return(__HL);
}

/*
 *  Xe[^XWX^iSRǰݒl̕ύX
 */
#pragma inline set_sr
void
set_sr(UH sr)
{
	__HL = sr;
	Asm("	push	hl");
	Asm("	pop		sr");
}

/*
 *  NMIׂĂ݂̊֎~
 */
/*
 *  uei #7vƁudiv͓̋@\ł邪ei߂͎s㒼ɗL
 *  Ȃ邽ei߂̗p
 */
#pragma inline disint
void
disint()
{
	Asm("	ei	7	");
}

/*
 *  ׂĂ݂̊
 */
#pragma inline enaint
void
enaint()
{
	Asm("	ei	0	");
}

/*
 *  fBL[T[`̂߂̃rbg}bvT[`֐
 *
 *  rbg}bv̉16rbggpCŉʃrbgŒDxɑΉ
 *  D
 */
#define	CPU_BITMAP_SEARCH

#pragma inline bitmap_search
UINT
bitmap_search(UINT bitmap)
{
	/*
	 *  ̃R[h́CbitmapiUINT^j16rbgł邱Ƃ肵
	 *  ĂD
	 */
	__HL = bitmap;
	Asm("	bs1f	a, hl");
	return (UINT)__A;
}

#endif /* _CPU_INSN_H_ */
