/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                     2003  by Advanced Data Controls, Corp
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: fdc37c935a.c,v 1.1 2008/06/17 00:04:58 suikan Exp $
 */

/*
 * X[pI/O FDC37C935A phCo
 */

#include <s_services.h>
#include "fdc37c935a.h"

/*
 *  
 */
void
smsc_init(void)
{
    /*
     * Enter Config mode 
     */
    sil_wrh_mem((VP)SMSC_CONFIG_PORT, (0x55 << 8));
    sil_wrh_mem((VP)SMSC_CONFIG_PORT, (0x55 << 8));

    /*
     * Init SCI0
     */
    /* Power on */
    smsc_config_write(0x22, (smsc_config_read(0x22) | 0x10));
    /* Select SCI0 */
    smsc_config_write(0x07, 0x04);
    /* Enable SCI0 */
    smsc_config_write(0x30, 0x01);
    /* Set SCI0 Base Address */
    smsc_config_write(0x60, (SMSC_SCI0_BASE_ADDR & 0xff00) >> 8);
    smsc_config_write(0x61, (SMSC_SCI0_BASE_ADDR & 0xff));    
    /* IRQ4 */
    smsc_config_write(0x70, 0x04);
    

    /*
     *  Exit Config mode
     */
    sil_wrh_mem((VP)SMSC_CONFIG_PORT, (0xAA << 8));
}


/*
 *  X[p[I/O(FDC37C935A)p ȈSIOhCo
 */

/*
 *  VAI/O|[gubN
 */
typedef struct sio_port_initialization_block {
    char dummy;
} SIOPINIB;

/*
 *  VAI/O|[gǗubN
 */
struct sio_port_control_block {
    const SIOPINIB  *siopinib;  /* VAI/O|[gubN */
    VP_INT          exinf;      /* g */
    BOOL    openflag;           /* I[vς݃tO */
    BOOL    sendflag;           /* M݃Cl[utO */
    BOOL    getready;           /* M */
    BOOL    putready;           /* 𑗐Mł */
};

/*
 * VAI/O|[gubN
 */
const SIOPINIB siopinib_table[TNUM_SIOP]= {{0}};

/*
 *  VAI/O|[gǗubÑGA
 */
SIOPCB  siopcb_table[TNUM_SIOP];


/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)  ((UINT)((siopid) - 1))
#define get_siopcb(siopid)  (&(siopcb_table[INDEX_SIOP(siopid)]))


/*
 * M?
 */ 
Inline BOOL
smsc_sci0_getready(SIOPCB *siopcb)
{
    return(((sil_reh_mem((VP)SMSC_SCI0_LSR) >> 8) & 0x01) != 0);
}

/*
 * 𑗐Mł邩?
 */
Inline BOOL
smsc_sci0_putready(SIOPCB *siopcb)
{
	return(((sil_reh_mem((VP)SMSC_SCI0_LSR) >> 8) & 0x60) != 0);
}

/*
 *  M̎o
 */
Inline char
smsc_sci0_getchar(SIOPCB *siopcb)
{
    return (sil_reh_mem((VP)SMSC_SCI0_RBR) >> 8);
}

/*
 *  M镶̏
 */
Inline void
smsc_sci0_putchar(SIOPCB *siopcb, char c)
{
    sil_wrh_mem((VP)SMSC_SCI0_THR, c << 8);
}

/*
 *  M݋
 */
Inline void
smsc_sci0_enable_send(SIOPCB *siopcb)
{

    sil_wrh_mem((VP)SMSC_SCI0_IER,
                (((sil_reh_mem((VP)SMSC_SCI0_IER) >> 8) | 0x02) << 8));   
}

/*
 *  M݋֎~
 */
Inline void
smsc_sci0_disable_send(SIOPCB *siopcb)
{
    sil_wrh_mem((VP)SMSC_SCI0_IER,
                (((sil_reh_mem((VP)SMSC_SCI0_IER) >> 8) & ~0x02) << 8));   
}

/*
 *  M݋
 */
Inline void
smsc_sci0_enable_rcv(SIOPCB *siopcb)
{

    sil_wrh_mem((VP)SMSC_SCI0_IER,
                (((sil_reh_mem((VP)SMSC_SCI0_IER) >> 8) | 0x01) << 8));   
}

/*
 *  M݋֎~
 */
Inline void
smsc_sci0_disable_rcv(SIOPCB *siopcb)
{
    sil_wrh_mem((VP)SMSC_SCI0_IER,
                (((sil_reh_mem((VP)SMSC_SCI0_IER) >> 8) & ~0x01) << 8));   
}





/*
 *  SIOhCȍ[`
 *  1|[gȂ߁C܂Ӗ͂Ȃ
 */
void
smsc_sci0_initialize()
{
    SIOPCB  *siopcb;
    UINT    i;

    /*
     *  VAI/O|[gǗubN̏
     */
    for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
        siopcb->siopinib = &(siopinib_table[i]);
        siopcb->openflag = FALSE;
        siopcb->sendflag = FALSE;
    }
}

/*
 *  ݈ȊȌ
 */
void
fdc37c935a_init(void)
{
    volatile UH dummy;
    
    /* BIT7 = 1 */
    sil_wrh_mem((VP)SMSC_SCI0_LCR, 0x83 << 8);

    /* Set BPS */
    sil_wrh_mem((VP)SMSC_SCI0_DLL, ((SMSC_SCI0_BPS & 0x00ff) << 8));   
    sil_wrh_mem((VP)SMSC_SCI0_DLM, ((SMSC_SCI0_BPS >> 8) << 8));

    /* BIT7 = 0 Divisor Latch BIT6 = 0 No Break : BIT3 = 0 NoParity
       : BIT2 = 0 1Stopbit : BIT1,0 = {1.1} 8bitData */    
    sil_wrh_mem((VP)SMSC_SCI0_LCR, 0x03 << 8);

    /* Do not use FIFO */
    sil_wrh_mem((VP)SMSC_SCI0_FCR, 0x0000);

    /* Clear Status */
    dummy = sil_reh_mem((VP)SMSC_SCI0_RBR);
    dummy = sil_reh_mem((VP)SMSC_SCI0_LSR);    
}

/*
 * I[vĂ|[g邩
 */
BOOL
smsc_sci0_openflag(void)
{
    return(siopcb_table[0].openflag);
}

/*
 * VAI/O|[g̃I[v
 */
SIOPCB *
smsc_sci0_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB      *siopcb;
    const SIOPINIB  *siopinib;


    siopcb = get_siopcb(siopid);
    siopinib = siopcb->siopinib;

    fdc37c935a_init();
        
    /* Enable Receive Data Interrupt */
    sil_wrh_mem((VP)SMSC_SCI0_IER, (0x01 << 8));
    sil_wrh_mem((VP)SMSC_SCI0_MCR, 0x08 << 8);

    /*
     * MS7729RSE01ł́CxM݂𔭐ĂȂƊ
     * x16݂̊Ă܂삵ȂD
     */
    /* M荞ݗv */
    sil_wrh_mem((VP)SMSC_SCI0_IER,
                (((sil_reh_mem((VP)SMSC_SCI0_IER) >> 8) | 0x02) << 8));   
    /* M荞ݗv֎~ */        
    sil_wrh_mem((VP)SMSC_SCI0_IER,
                (((sil_reh_mem((VP)SMSC_SCI0_IER) >> 8) & ~0x02) << 8));   

    siopcb->exinf = exinf;
    siopcb->getready = siopcb->putready = FALSE;
    siopcb->openflag = TRUE;

    return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
smsc_sci0_cls_por(SIOPCB *siopcb)
{
    sil_wrh_mem((VP)SMSC_SCI0_IER, 0x00);      /* ݂̋֎~ */
    siopcb->openflag = FALSE;
}

/*
 * VAI/O|[gւ̃|[Oł̏o
 */
void
fdc37c935a_pol_putc(char c)
{
    while(((sil_reh_mem((VP)SMSC_SCI0_LSR) >> 8) & 0x60) == 0)
        ;

    sil_wrh_mem((VP)SMSC_SCI0_THR, c << 8);
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
smsc_sci0_snd_chr(SIOPCB *siopcb, char c)
{
    if (smsc_sci0_putready(siopcb)){
        smsc_sci0_putchar(siopcb, c);
        return(TRUE);
    }
    return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
smsc_sci0_rcv_chr(SIOPCB *siopcb)
{
    if (smsc_sci0_getready(siopcb)) {
        return((INT)(UB) smsc_sci0_getchar(siopcb));
    }
    return(-1);
}


/*
 *  VAI/O|[g̃R[obN̋
 */
void
smsc_sci0_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{

    switch (cbrtn) {
        case SIO_ERDY_SND:
            smsc_sci0_enable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            smsc_sci0_enable_rcv(siopcb);
            break;
    }
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
smsc_sci0_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
        case SIO_ERDY_SND:
            smsc_sci0_disable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            smsc_sci0_disable_rcv(siopcb);
            break;
    }
}

/*
 *  VAI/O|[gɑ΂銄ݏ
 */
static void
smsc_sci0_isr_siop(SIOPCB *siopcb)
{
    if (smsc_sci0_getready(siopcb)) {
        /*
         *  MʒmR[obN[`ĂяoD
         */
        smsc_sci0_ierdy_rcv(siopcb->exinf);
    }
    if (smsc_sci0_putready(siopcb)) {
        /*
         *  M\R[obN[`ĂяoD
         */
        smsc_sci0_ierdy_snd(siopcb->exinf);
    }
}

/*
 *  SIO̊݃T[rX[`
 */
void
smsc_sci0_isr()
{
    smsc_sci0_isr_siop(&(siopcb_table[0]));
}
