/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.c,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

/*
 *	vZbTˑW[iSH2pj
 *@@@@@J[lŎgp`
 *@@@@@@C֐̎
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include <sh2.h>
#include <sil.h>

/*
 *  ^XNReLXgł̊݃}XN
 */
#ifdef SUPPORT_CHG_IPM
UW	task_intmask;
#endif /* SUPPORT_CHG_IPM */

/*
 *  ^XNReLXgł̊݃}XN
 */
UW	int_intmask;

/*
 *  ݁^CPUOlXgJE^
 */
UW	intnest;

/*
 *  IWĩxN^x[XWX^̕ۑ̈
 */
#ifdef KERNEL_HAS_A_VECTOR_TABLE
static VP org_vbr;
#endif /* KERNEL_HAS_A_VECTOR_TABLE */

#ifdef SUPPORT_CPU_EXC_ENTRY_CHECK

/*
 *  CPUO̗v
 */
#ifndef NUM_EXC
#define NUM_EXC	(6 + 2)
#endif	/*  NUM_EXC  */

/*
 *  o^ꂽCPUO̗v
 */
static UW num_exc;

/*
 *  CPUO̓̐擪AhX
 */
static FP exc_entries[NUM_EXC];

#endif /* SUPPORT_CPU_EXC_ENTRY_CHECK */

/*
 *  vZbTˑ̏
 */
void
cpu_initialize()
{
	/*
	 *  ^XNReLXgł̊݃}XN̏
	 */
#ifdef SUPPORT_CHG_IPM
	task_intmask = 0x0000u;
#endif /* SUPPORT_CHG_IPM */

	/*
	 *  ݁^CPUOlXgJE^̏
	 */
	intnest = 1u;

#ifndef GDB_STUB

	/*
	 * 荞݃Rg[̏
	 */
	sh2_init_intcontorller ();

#endif	/*  GDB_STUB  */

#ifdef KERNEL_HAS_A_VECTOR_TABLE
	/*
	 *  xN^e[u͏ltϐizjɂ̂ŁA
	 *  X^[gAbv[`dataZNVRs[ۂ
	 *  B
	 *  iŏKv͂ȂBj
	 */
	
	/*
	 *  xN^x[XWX^̏
	 */
	org_vbr = current_vbr();
	set_vbr((VP)vector_table);
#endif /* KERNEL_HAS_A_VECTOR_TABLE */

#ifdef SUPPORT_CPU_EXC_ENTRY_CHECK
	num_exc = 0;
#endif /* SUPPORT_CPU_EXC_ENTRY_CHECK */

}

/*
 *  vZbTˑ̏I
 */
void
cpu_terminate()
{
#ifdef KERNEL_HAS_A_VECTOR_TABLE
	set_vbr(org_vbr);
#endif /* KERNEL_HAS_A_VECTOR_TABLE */
}

/*
 *  CPUOnh̐ݒ
 *
 *  xNgԍ excno CPUOnh̋NԒn exchdr ɐݒ肷D
 */
void
define_exc(EXCNO excno, FP exchdr)
{
	/*  SH1݂͊CPUO`  */
	define_inh((INHNO)excno, exchdr);

#ifdef SUPPORT_CPU_EXC_ENTRY_CHECK
//	CHECK_PAR(num_exc < NUM_EXC);
	exc_entries[num_exc++] = exchdr;
#endif /* SUPPORT_CPU_EXC_ENTRY_CHECK */
}

#ifdef SUPPORT_CPU_EXC_ENTRY_CHECK
/*
 *  CPUO̓Ŋ݋֎~܂ł̖ߐ
 */
#define NUM_INST_DIS_INT	5


/*
 *  ݂̖߂̃`FbN
 *
 *  @
 *  @@VP pcFX^bNɐς܂ꂽ߂Ԓn
 *  @߂l
 *  @@TRUEF߂悪CPUO̓i݋֎~Oj
 *  @@FALSEF߂悪LȊO
 *  @l
 *  @@݂̏oŊ݋֎~ŌĂ΂B
 */

/* cpu_support.Sret_intĂ΂̂ 	*/
/* wb_[t@Cɂ͊܂߂ȂB 		*/
BOOL check_cpu_exc_entry(VP pc)   throw();

BOOL check_cpu_exc_entry(VP pc)
{
	UW i;
	UH *entry;	/* 2oCg߂ւ̃|C^ */
	
	for(i = 0; i < num_exc; i++) {
		entry = (UH *)exc_entries[i];
		if (((UW)entry <= (UW)pc) &&
		     ((UW)pc <= (UW)(entry + NUM_INST_DIS_INT)) ) {
			return TRUE;
		}
	}
	return FALSE;
}


#endif /* SUPPORT_CPU_EXC_ENTRY_CHECK */



#ifdef SUPPORT_CHG_IPM

/*
 *  ݃}XN̕ύX
 *
 *  chg_ipm g IPM 0xfiNMI ȊÔׂĂ݂̊֎~jɕύX
 *  邱Ƃ͂łȂDNMI ȊÔׂĂ݂̊֎~ꍇɂ́C
 *  loc_cpu ɂCPUbNԂɂ΂悢D
 *  IPM  0 ȊO̎ɂC^XNfBXpb`͕ۗȂDIPM ́C
 *  ^XNfBXpb`ɂāCVsԂɂȂ^XNֈp
 *  D̂߁C^XNsɁCʂ̃^XNɂ IPM ύX
 *  ꍇDJSPJ[lł́CIPM ̕ύX̓^XNO[`
 *  ɂĂN邪CɂĈȂ󋵂͏Ȃ
 *  vDIPM ̒lɂă^XNfBXpb`֎~ꍇɂ́C
 *  dis_dsp 𕹗p΂悢D
 */
SYSCALL ER
chg_ipm(IPM ipm)
{
	ER	ercd;

	LOG_CHG_IPM_ENTER(ipm);
	CHECK_TSKCTX_UNL();
	CHECK_PAR(0 <= ipm && ipm <= (MAX_IPM - 1) );

	t_lock_cpu();
	task_intmask = (ipm << 4);
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_CHG_IPM_LEAVE(ercd);
	return(ercd);
}

/*
 *  ݃}XN̎Q
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
	ER	ercd;

	LOG_GET_IPM_ENTER(p_ipm);
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	*p_ipm = (task_intmask >> 4);
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_GET_IPM_LEAVE(ercd, *p_ipm);
	return(ercd);
}

#endif /* SUPPORT_CHG_IPM */

/*
 * o^ĂȂOƌĂяo
 */
void cpu_experr(EXCSTACK *sp)
{
    syslog(LOG_EMERG, "Exception error occurs.");

    syslog(LOG_EMERG, "PC = 0x%08x SR = 0x%08x PR = 0x%08x",
    			sp->pc, sp->sr, sp->pr);

    syslog(LOG_EMERG, "r0 = 0x%08x r1 = 0x%08x r2 = 0x%08x",
    			sp->r0, sp->r1, sp->r2);
    syslog(LOG_EMERG, "r3 = 0x%08x r4 = 0x%08x r5 = 0x%08x",
    			sp->r3, sp->r4, sp->r5);
    syslog(LOG_EMERG, "r6 = 0x%08x r7 = 0x%08x r8 = 0x%08x",
    			sp->r6, sp->r7, sp->r8);
    syslog(LOG_EMERG, "r9 = 0x%08x r10 = 0x%08x r11 = 0x%08x",
    			sp->r9, sp->r10, sp->r11);
    syslog(LOG_EMERG, "r12 = 0x%08x r13 = 0x%08x r14 = 0x%08x",
    			sp->r12, sp->r13, sp->r14);
    			/*  OÕX^bN|C^̒l  */
    syslog(LOG_EMERG, "r15 = 0x%08x", (sp->r15)+19*4);

    while(1);
}


/*
 *  ubN색Cu
 *	(ItIs̗p)
 *
 *  ֐̎dĺCANSI C Cu̎dlƓDWCû̂
 *  gǂ\D
 *
 */
VP
_dummy_memcpy(VP dest, VP src, UINT len)
{
	VB	*d = (VB *)dest;
	VB	*s = (VB *)src;

	while (len-- > 0) {
		*d++ = *s++;
	}
	return(dest);
}

