/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2003-2004 by CHUO ELECTRIC WORKS Co.,LTD. JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */
/*
 *  ()쏊ITRONSH1CPU{[hp
 *  n[hEFA̒`
 */

#ifndef _ZUNDA_SH1_H_
#define _ZUNDA_SH1_H_

/* rbh`lO */
#if 0 /* sh1sci2.cɒ`Ă */
#define SCI_SMR0	((VH *)0x5fffec0)	/* VA[hWX^ */
#define SCI_BRR0	((VH *)0x5fffec1)	/* rbg[gWX^ */
#define SCI_SCR0	((VH *)0x5fffec2)	/* VARg[WX^ */
#define SCI_TDR0	((VH *)0x5fffec3)	/* gX~bgf[^WX^ */
#define SCI_SSR0	((VH *)0x5fffec4)	/* VAXe[^XWX^ */
#define SCI_RDR0	((VH *)0x5fffec5)	/* V[uf[^WX^ */

/* rbh`lP */
#define SCI_SMR1	((VH *)0x5fffec8)	/* VA[hWX^ */
#define SCI_BRR1	((VH *)0x5fffec9)	/* rbg[gWX^ */
#define SCI_SCR1	((VH *)0x5fffeca)	/* VARg[WX^ */
#define SCI_TDR1	((VH *)0x5fffecb)	/* gX~bgf[^WX^ */
#define SCI_SSR1	((VH *)0x5fffecc)	/* VAXe[^XWX^ */
#define SCI_RDR1	((VH *)0x5fffecd)	/* V[uf[^WX^ */
#endif	/* sh1sci2.c */

#define PBCR1_TD1_RD1_MASK	~0xf0u		/*  TxD1,RxD1[qݒp}XN	*/
#define PBCR1_TD1 		0x80u		/*  TxD1[qݒp}N  	*/
#define PBCR1_RD1 		0x20u		/*  RxD1[qݒp}N  	*/

/* `^c */
#define AD_DRAH		((VH *)0x5fffee0)	/* A/D f[^WX^` Hiޯ9`2j*/
#define AD_DRAL		((VH *)0x5fffee1)	/* A/D f[^WX^` Liޯ1`0j*/
#define AD_DRBH		((VH *)0x5fffee2)	/* A/D f[^WX^a Hiޯ9`2j*/
#define AD_DRBL		((VH *)0x5fffee3)	/* A/D f[^WX^a Liޯ1`0j*/
#define AD_DRCH		((VH *)0x5fffee4)	/* A/D f[^WX^b Hiޯ9`2j*/
#define AD_DRCL		((VH *)0x5fffee5)	/* A/D f[^WX^b Liޯ1`0j*/
#define AD_DRDH		((VH *)0x5fffee6)	/* A/D f[^WX^c Hiޯ9`2j*/
#define AD_DRDL		((VH *)0x5fffee7)	/* A/D f[^WX^c Liޯ1`0j*/
#define AD_CSR		((VH *)0x5fffee8)	/* A/D Rg[^Xe[^XWX^ */
#define AD_CR		((VH *)0x5fffee9)	/* A/D Rg[WX^ 		 */
#define	ADF			0x80		/* ADF				*/
#define	ADST			0x20		/* A/D start			*/

#if 0 /* sh1itu.hɒ`Ă */
/* hst */
#define ITU_TSTR	((VH *)0x5ffff00)	/* ^C}X^[gWX^ */
#define ITU_TSNC	((VH *)0x5ffff01)	/* ^C}VNWX^ */
#define ITU_TMDR	((VH *)0x5ffff02)	/* ^C}[hWX^ 	*/
#define ITU_TFCR	((VH *)0x5ffff03)	/* ^C}t@NVRg[WX^ */
#define ITU_TOER	((VH *)0x5ffff31)	/* ^C}AEgvbg}X^Cl[uWX^ */

/* hst`lO */
#define ITU_TCR0	((VH *)0x5ffff04)	/* ^C}Rg[WX^0 		*/
#define ITU_TIOR0	((VH *)0x5ffff05)	/* ^C}h^nRg[WX^0 	*/
#define ITU_TIER0	((VH *)0x5ffff06)	/* ^C}C^vgCl[uWX^0 */
#define ITU_TSR0	((VH *)0x5ffff07)	/* ^C}Xe[^XWX^0 */
#define ITU_TCNT0	((VH *)0x5ffff08)	/* ^C}JE^0 */
#define ITU_GRA0	((VH *)0x5ffff0a)	/* WFlWX^`0 */
#define ITU_GRB0	((VH *)0x5ffff0c)	/* WFlWX^a0 */
#endif /* sh1itu.h */

/* hst`lP */
#define ITU_TCR1	((VH *)0x5ffff0e)	/* ^C}Rg[WX^1 */
#define ITU_TIOR1	((VH *)0x5ffff0f)	/* ^C}h^nRg[WX^1 */
#define ITU_TIER1	((VH *)0x5ffff10)	/* ^C}C^vgCl[uWX^1 */
#define ITU_TSR1	((VH *)0x5ffff11)	/* ^C}Xe[^XWX^1 */
#define ITU_TCNT1	((VH *)0x5ffff12)	/* ^C}JE^1 */
#define ITU_GRA1	((VH *)0x5ffff14)	/* WFlWX^`1 */
#define ITU_GRB1	((VH *)0x5ffff16)	/* WFlWX^a1 */

/* hst`lQ */
#define ITU_TCR2	((VH *)0x5ffff18)	/* ^C}Rg[WX^2  */
#define ITU_TIOR2	((VH *)0x5ffff19)	/* ^C}h^nRg[WX^2  */
#define ITU_TIER2	((VH *)0x5ffff1a)	/* ^C}C^vgCl[uWX^2  */
#define ITU_TSR2	((VH *)0x5ffff1b)	/* ^C}Xe[^XWX^2  */
#define ITU_TCNT2	((VH *)0x5ffff1c)	/* ^C}JE^2  */
#define ITU_GRA2	((VH *)0x5ffff1e)	/* WFlWX^`2 */
#define ITU_GRB2	((VH *)0x5ffff20)	/* WFlWX^a2 */

/* hst`lR */
#define ITU_TCR3	((VH *)0x5ffff22)	/* ^C}Rg[WX^3 */
#define ITU_TIOR3	((VH *)0x5ffff23)	/* ^C}h^nRg[WX^3 */
#define ITU_TIER3	((VH *)0x5ffff24)	/* ^C}C^vgCl[uWX^3 */
#define ITU_TSR3	((VH *)0x5ffff25)	/* ^C}Xe[^XWX^3 */
#define ITU_TCNT3	((VH *)0x5ffff26)	/* ^C}JE^3 */
#define ITU_GRA3	((VH *)0x5ffff28)	/* WFlWX^`3 */
#define ITU_GRB3	((VH *)0x5ffff2a)	/* WFlWX^a3 */
#define ITU_BRA3	((VH *)0x5ffff2c)	/* obt@WX^`3 */
#define ITU_BRB3	((VH *)0x5ffff2e)	/* obt@WX^a3 */

/* hst`lS */
#define ITU_TCR4	((VH *)0x5ffff32)	/* ^C}Rg[WX^4 */
#define ITU_TIOR4	((VH *)0x5ffff33)	/* ^C}h^nRg[WX^4 */
#define ITU_TIER4	((VH *)0x5ffff34)	/* ^C}C^vgCl[uWX^4 */
#define ITU_TSR4	((VH *)0x5ffff35)	/* ^C}Xe[^XWX^4 */
#define ITU_TCNT4	((VH *)0x5ffff36)	/* ^C}JE^4 */
#define ITU_GRA4	((VH *)0x5ffff38)	/* WFlWX^`4 */
#define ITU_GRB4	((VH *)0x5ffff3a)	/* WFlWX^a4 */
#define ITU_BRA4	((VH *)0x5ffff3c)	/* obt@WX^`4 */
#define ITU_BRB4	((VH *)0x5ffff3e)	/* obt@WX^a4 */

/* hst */
#if 0 /* sh1itu.hɒ`Ă */
#ifndef	TSR_IMFA
#define TSR_IMFA	0x0001			/* GRA߱ϯ/߯ķ׸A */
#endif
#endif /* sh1itu.h */

#ifndef	TSR_IMFB
#define TSR_IMFB	0x0002			/* GRB߱ϯ/߯ķ׸B */
#endif
#define TSR_OVF	 	0x0004				/* ް۰׸ */

/* cl`b */
#define DMAC_DMAOR	((VH *)0x5ffff48)		/* DMA Iy[VWX^ */

/* cl`b`lO */
#define DMAC_SAR0	((VH *)0x5ffff40)	/* DMA \[XAhXWX^0 */
#define DMAC_DAR0	((VH *)0x5ffff44)	/* DMA fXeBl[VAhXWX^0 */
#define DMAC_TCR0	((VH *)0x5ffff4a)	/* DMA gXt@JEgWX^0 */
#define DMAC_CHCR0	((VH *)0x5ffff4e)		/* DMA `lRg[WX^0 */

/* cl`b`lP */
#define DMAC_SAR1	((VH *)0x5ffff50)	/* DMA \[XAhXWX^1 */
#define DMAC_DAR1	((VH *)0x5ffff54)	/* DMA fXeBl[VAhXWX^1 */
#define DMAC_TCR1	((VH *)0x5ffff5a)	/* DMA gXt@JEgWX^1 */
#define DMAC_CHCR1	((VH *)0x5ffff5e)		/* DMA `lRg[WX^1 */
/* cl`b`lQ */

#define DMAC_SAR2	((VH *)0x5ffff60)	/* DMA \[XAhXWX^2 */
#define DMAC_DAR2	((VH *)0x5ffff64)	/* DMA fXeBl[VAhXWX^2 */
#define DMAC_TCR2	((VH *)0x5ffff6a)	/* DMA gXt@JEgWX^2 */
#define DMAC_CHCR2	((VH *)0x5ffff6e)		/* DMA `lRg[WX^2 */

/* cl`b`lR */
#define DMAC_SAR3	((VH *)0x5ffff70)	/* DMA \[XAhXWX^3 */
#define DMAC_DAR3	((VH *)0x5ffff74)	/* DMA fXeBl[VAhXWX^3 */
#define DMAC_TCR3	((VH *)0x5ffff7a)	/* DMA gXt@JEgWX^3 */
#define DMAC_CHCR3	((VH *)0x5ffff7e)		/* DMA `lRg[WX^3 */

/* ݃Rg[ */
#define INTC_IPRA	((VH *)0x5ffff84)	/* ݗD惌xݒ背WX^` */
#define INTC_IPRB	((VH *)0x5ffff86)	/* ݗD惌xݒ背WX^a */
#define INTC_IPRC	((VH *)0x5ffff88)	/* ݗD惌xݒ背WX^b */
#define INTC_IPRD	((VH *)0x5ffff8a)	/* ݗD惌xݒ背WX^c */
#define INTC_IPRE	((VH *)0x5ffff8c)	/* ݗD惌xݒ背WX^d */
#define INTC_ICR	((VH *)0x5ffff8e)	/* ݃Rg[WX^ */

/* [Uu[NRg[ */
#define UBC_BARH	((VH *)0x5ffff90)	/* u[NAhXWX^g */
#define UBC_BARL	((VH *)0x5ffff92)	/* u[NAhXWX^k */
#define UBC_BAMRH	((VH *)0x5ffff94)	/* u[NAhX}XNWX^g */
#define UBC_BAMRL	((VH *)0x5ffff96)	/* u[NAhX}XNWX^k */
#define UBC_BBR		((VH *)0x5ffff98)	/* u[NoXTCNWX^ */

/* oXRg[ */
#define BSC_BCR		((VH *)0x5ffffa0)	/* oXRg[WX^ */
#define BSC_WCR1	((VH *)0x5ffffa2)	/* EFCgXe[g䃌WX^1 */
#define BSC_WCR2	((VH *)0x5ffffa4)	/* EFCgXe[g䃌WX^2 */
#define BSC_WCR3	((VH *)0x5ffffa6)	/* EFCgXe[g䃌WX^3 */
#define BSC_DCR		((VH *)0x5ffffa8)	/* DRAM GARg[WX^ */
#define BSC_PCR		((VH *)0x5ffffaa)	/* DRAM peBRg[WX^ */
#define BSC_RCR		((VH *)0x5ffffac)	/* tVRg[WX^ */
#define BSC_RTCSR	((VH *)0x5ffffae)	/* tV^C}Rg/Xe^W */
#define BSC_RTCNT	((VH *)0x5ffffb0)	/* tV^C}JE^ */
#define BSC_RTCOR	((VH *)0x5ffffb2)	/* tV^CRX^gWX^ */

/* vcs */
#define WDT_TCSR	((VH *)0x5ffffb8)	/* ^C}Rg[^Xe[^XWX^ */
#define WDT_TCNT	((VH *)0x5ffffb8)	/* ^C}JE^iײāj*/
#define WDT_TCNT_R	((VH *)0x5ffffb9)	/* ^C}JE^iذށj*/
#define WDT_RSTCSR	((VH *)0x5ffffba)	/* ZgRg/Xe^XWX^iײāj*/
#define WDT_RSTCSR_R	((VH *)0x5ffffbb)		/* ZgRg/Xe^XWX^iذށj*/

/* d */
#define SYS_SBYCR	((VH *)0x5ffffbc)	/* X^oCRg[WX^ */

/* |[g``b */
#define PA_DR		((VH *)0x5ffffc0)	/* |[g` f[^WX^ */
#define PB_DR		((VH *)0x5ffffc2)	/* |[ga f[^WX^ */
#define PC_DR		((VH *)0x5ffffd0)	/* |[gb f[^WX^ */

#define PB_RTS0		(1<<2)  		/* RTS0 ͒[qiPB2j*/
#define PB_CTS0		(1<<3)  		/* CTS0 o͒[qiPB3j*/
#define PB_TXE1		(1<<5)  		/* TXE1 o͒[qiPB5j*/
#define PB_RXD0		(1<<8)  		/* RxD0 ͒[qiPB8j*/
#define PB_TXD0		(1<<9)  		/* TxD0 o͒[qiPB9j*/
#define PB_RXD1		(1<<10) 		/* RxD1 ͒[qiPB10j*/
#define PB_TXD1		(1<<11)			/* TxD1 o͒[qiPB11j*/

/* st@NVRg[ */
#define PFC_PAIOR	((VH *)0x5ffffc4)	/* |[g` hnWX^ */
#define PFC_PBIOR	((VH *)0x5ffffc6)	/* |[ga hnWX^ */
#define PFC_PACR1	((VH *)0x5ffffc8)	/* |[g` Rg[WX^1 */
#define PFC_PACR2	((VH *)0x5ffffca)	/* |[g` Rg[WX^2 */
#define PFC_PBCR1	((VH *)0x5ffffcc)	/* |[ga Rg[WX^1 */
#define PFC_PBCR2	((VH *)0x5ffffce)	/* |[ga Rg[WX^2 */
#define PFC_CASCR	((VH *)0x5ffffee)	/* JAhXXgusR۰٥W */

/* sob */
#define TPC_TPMR	((VH *)0x5fffff0)	/* TPC o̓[hWX^ */
#define TPC_TPCR	((VH *)0x5fffff1)	/* TPC o̓Rg[WX^ */
#define TPC_NDERB	((VH *)0x5fffff2)	/* lNXgf[^Cl[uWX^a */
#define TPC_NDERA	((VH *)0x5fffff3)	/* lNXgf[^Cl[uWX^` */
#define TPC_NDRB	((VH *)0x5fffff4)	/* lNXgf[^WX^a */
#define TPC_NDRA	((VH *)0x5fffff5)	/* lNXgf[^WX^` */
#define TPC_NDRB_2	((VH *)0x5fffff6)	/* lNXgf[^WX^aioضވقȂ鎞j*/
#define TPC_NDRA_2	((VH *)0x5fffff7)	/* lNXgf[^WX^`ioضވقȂ鎞j*/

/* ݃xN^ԍ */
#define INT_NMI		11		/* NMI */
#define INT_UB		12		/* [Uu[N */
#define INT_IRQ0	64		/* O[q IRQ0 */
#define INT_IRQ1	65		/* O[q IRQ1 */
#define INT_IRQ2	66		/* O[q IRQ2 */
#define INT_IRQ3	67		/* O[q IRQ3 */
#define INT_IRQ4	68		/* O[q IRQ4 */
#define INT_IRQ5	69		/* O[q IRQ5 */
#define INT_IRQ6	70		/* O[q IRQ6 */
#define INT_IRQ7	71		/* O[q IRQ7 */
#define INT_DEI0	72		/* DMAC `l0 */
#define INT_DEI1	74		/* DMAC `l1 */
#define INT_DEI2	76		/* DMAC `l2 */
#define INT_DEI3	78		/* DMAC `l3 */
#define INT_IMIA0	80		/* ITU `l0 RyA}`/CvăLv`A0 */
#define INT_IMIB0	81		/* ITU `l0 RyA}`/CvăLv`B0 */
#define INT_OVI0	82		/* ITU `l0 I[ot[0 */
#define INT_IMIA1	84		/* ITU `l1 RyA}`/CvăLv`A1 */
#define INT_IMIB1	85		/* ITU `l1 RyA}`/CvăLv`B1 */
#define INT_OVI1	86		/* ITU `l1 I[ot[1 */
#define INT_IMIA2	88		/* ITU `l2 RyA}`/CvăLv`A2 */
#define INT_IMIB2	89		/* ITU `l2 RyA}`/CvăLv`B2 */
#define INT_OVI2	90		/* ITU `l2 I[ot[2 */
#define INT_IMIA3	92		/* ITU `l3 RyA}`/CvăLv`A3 */
#define INT_IMIB3	93		/* ITU `l3 RyA}`/CvăLv`B3 */
#define INT_OVI3	94		/* ITU `l3 I[ot[3 */
#define INT_IMIA4	96		/* ITU `l4 RyA}`/CvăLv`A4 */
#define INT_IMIB4	97		/* ITU `l4 RyA}`/CvăLv`B4 */
#define INT_OVI4	98		/* ITU `l4 I[ot[4 */
#define INT_ERI0	100		/* SCI `l0 MG[ */
#define INT_RXI0	101	 	/* SCI `l0 M */
#define INT_TXI0	102		/* SCI `l0 Mf[^GveB */
#define INT_TEI0	103		/* SCI `l0 MI */
#define INT_ERI1	104		/* SCI `l1 MG[ */
#define INT_RXI1	105		/* SCI `l1 M */
#define INT_TXI1	106		/* SCI `l1 Mf[^GveB */
#define INT_TEI1	107		/* SCI `l1 MI */
#define INT_PEI		108		/* peB */
#define INT_ADI		109		/* A/D Gh */
#define INT_ITI		112		/* EHb`hbN^C}iC^[o^C}j*/
#define INT_CMI		113		/* tbVRg[RyA}b` */

/*
 *  GDB STUBďo[`
 */
#ifndef _MACRO_ONLY
#ifdef GDB_STUB

#define zunda_sh1_exit	gdb_stub_exit
#define zunda_sh1_putc	gdb_stub_putc

Inline void
gdb_stub_exit(void)
{
	Asm("trapa #0xff"::);		/*    */
}

/*
 *  gdb stubɂo
 */
Inline int
gdb_stub_putc(int c)
{
	Asm("mov   #0x00,r0
	     mov   %0,r4
	     trapa #0x21"
               : /* no output */
               : "r"(c)
               : "r0","r4");
	return(c);
}

/*
 *  ROM̏ꍇ
 */
#else /* GDB_STUB */

Inline void
zunda_sh1_exit(void)
{
	while(1);
}

extern void	sh1sci_putc_pol(char c);	/*  sh1sci2.c  */

Inline void 
zunda_sh1_putc(char c)
{
	sh1sci_putc_pol(c);
}

#endif /* GDB_STUB */
#endif /* _MACRO_ONLY */
#endif /* _ZUNDA_SH1_H_ */
