/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2003-2004 by CHUO ELECTRIC WORKS Co.,LTD. JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */
/*
 *	^[QbgVXeˑW[
 *	()쏊ITRONSH1CPU{[hp
 */
 
#include <s_services.h>
#include "kernel_id.h"

#include <sh1.h>
#include "sys_support.h"

/*
 *  TINETgp
 */
#ifdef	SUPPORT_INET4
#include <sh1_sil.h>
#include <tinet_sys_config.h>
/*
 *  NIC (RTL8019AS) Ɋւ`
 *  TINETgptinet_sys_config.h ֈړ邱
 */
/*#define ED_BASE_ADDRESS	0x06000000	*/	/* NIC ̃WX^x[XAhX */
/*#define INHNO_IF_ED		IRQ5		*/	/* IRQ5 */
/*#define ED_PRI		7		*/	/* Dx=7 */
/*#define ED_LEVEL0		0		*/	/* ݋֎~  */
/*#define ED_IPR		IPRB		*/	/* DxWX^ */
/*#define ED_IPR_SHIFT		8		*/	/* DxWX^rbgʒu */
#endif	/* SUPPORT_INET4 */

/*
 *  ROMICEgpNMI܂łROMxN^e[ü
 */
#define ROMVECT_START	0			/* ROM̃xN^e[u͂OԒn 	*/
#define ROMVECT_SIZE	((NMI+1)*sizeof(FP))	/* ROM̃xN^e[uTCY 		*/

/*
 *  ჌x̃^[QbgVXeˑ̏ _hardware_init_hook
 *
 *  X^[gAbvW[̒ŁC̏̑OɌĂяoD
 */
void
hardware_init_hook(void)
{
	/* WCR3:EGCgRg[WX^R
	 * WPU=1    WAIT[qvAbv
	 * A02LW=00 GA0,21ݸ޳
	 * A6LW=00  GA6  1ݸ޳
	 */
	sil_wrh_mem(BSC_WCR3, 0x8000); 
	
	/* BCR:oXRg[WX^
	 * DRANE=0   ر1͊O
	 * IOE=0     ر6͊O
	 * WARP=0    ɰӰ:OƓ𓯎ɍsȂ
	 * RDDTY=0   RDMHI T150%
	 * BAS=0     WRH,WRL,A0ML
	 */
	sil_wrh_mem(BSC_BCR, 0x0000);
	
	/* WCR1:EGCgRg[WX^P
	 * read cycle state
	 * wait[qTvȂ
	 * RWx=0  GA1,3,4,5,7 1ðČŒ
	 * RWx=0  GA0,2,6 1ð+ݸ޳āiv3ðāj
	 * WW1=1  GA1O 2ð
	 */
	sil_wrh_mem(BSC_WCR1, 0x00ff);
	
	/* WCR2:EGCgRg[WX^Q
	 * DMAȂ̂ŏl̂܂
	 */
	sil_wrh_mem(BSC_WCR2, 0xffff); 
	
	/*
	 * o`Aoao̓obt@
	 */
	sil_wrh_mem(PA_DR, VAL_PA_DR);
	sil_wrh_mem(PB_DR, VAL_PB_DR); 

	/*
	 * o`o͏isys_support.hQƁj
	 */
	sil_wrh_mem(PFC_PACR1, VAL_PFC_PACR1);
	sil_wrh_mem(PFC_PACR2, VAL_PFC_PACR2);
                                        
	sil_wrh_mem(PFC_PAIOR, VAL_PFC_PAIOR);
                    
	sil_wrh_mem(PFC_PBCR1, VAL_PFC_PBCR1);
	sil_wrh_mem(PFC_PBCR2, VAL_PFC_PBCR2);
	sil_wrh_mem(PFC_PBIOR, VAL_PFC_PBIOR);

	sil_wrh_mem(PFC_CASCR, VAL_PFC_CASCR);

}

/*
 *  \tgEFAiɃCujɈˑĕKvȏ software_init_hook
 *
 *  X^[gAbvW[̒ŁCJ[lNOɌĂяoD
 */
#ifdef	PARTNER
void
software_init_hook(void)
{
	/*
	 *  ROMICEgpROMxN^e[u]
	 */
	extern FP vector_table[];
	memcpy(vector_table, ROMVECT_START, ROMVECT_SIZE);
}
#endif

/*
 *  NIC n[hEFA荞݋
 *  TINETgpKv
 */
#ifdef	SUPPORT_INET4
void
ed_ena_inter(void)
{
	SIL_PRE_LOC;
	SIL_LOC_INT();
	define_int_plevel(ED_IPR, ED_PRI, ED_IPR_SHIFT);// Dx=ED_PRI
	SIL_UNL_INT();
}

/*
 *  NIC n[hEFA荞݋֎~
 *  TINETgpKv
 */
void
ed_dis_inter(void)
{
	SIL_PRE_LOC;
	SIL_LOC_INT();
	define_int_plevel(ED_IPR, ED_LEVEL0, ED_IPR_SHIFT);// Dx=0
	SIL_UNL_INT();
}
#endif	/* SUPPORT_INET4 *//* end */

