/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 */

/*
 *  n[hEFA̒`
 */
#ifndef _LUXUN2_H_
#define _LUXUN2_H_

#include "s1c33.h"

#ifndef _MACRO_ONLY
extern int __START_bss[];			/* V{			*/
extern int __END_bss[];
extern int __START_data[];
extern int __END_data[];
extern int __START_vector[];
extern int __END_vector[];
extern int __START_data_lma[];
extern int __END_data_lma[];
extern int __START_vector_lma[];
extern int __END_vector_lma[];
#endif /* _MACRO_ONLY */

/*
 *	GA擪/I[AhX
 *  Top/tail address of each area.
 */
#define STACKTOP	((void *)0x00004000)

#define BSS_START	__START_bss		/* RAM̈̐擪 		*/
#define BSS_END		__END_bss		/* RAM̈̏I[		*/
#define DATA_START	__START_data		/* RAM̏ϐ̈擪	*/
#define IDATA_START	__START_data_lma	/* ROM̏ϐ̈擪	*/
#define IDATA_END	__END_data_lma		/* ROM̏ϐ̈I[	*/
#define VECTOR_START	__START_vector		/* RAM̃xN^e[ü擪*/
#define IVECTOR_START	__START_vector_lma	/* ROM̃xN^e[ü擪*/
#define IVECTOR_END	__END_vector_lma	/* ROM̃xN^e[üI[*/

#endif /*  _LUXUN2_H_ */
