/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 */


/*
 *	vZbTˑW[(S1C33p)
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include "itron.h"
#include "s1c33.h"
#include "sys_config.h"

/*
 *  CPUbNɕ
 */
UINT	tps_OrgIntLevel;

/*
 *  ݃lXgJE^
 */
UINT	tps_IntNestCnt;

/*
 *  ݐ䃌WX^ ʒu菈
 */
ER	get_Offset(INTNO);
ER	get_BitFlag(INTNO);

/*
 *  vZbTˑ̏
 */
void
cpu_initialize()
{
	tps_IntNestCnt = 0;			/* ݃lXgJEg̏ */
	tps_OrgIntLevel = TPS_INIT_INTLEVEL;

	/*
	 *  荞݋tOݒ肵AOSǗ̊荞݂}XN
	 */
	set_psr((TPS_CPULOCK_LEV << 8) | S1C33_PSR_FLAG_IE);

}

/*
 *  vZbTˑ̏I
 */
void
cpu_terminate()
{

}

/*
 *  ^XNN
 */
void
activate_r(void)
{
	unlock_cpu();
	Asm("xld.w %r0, ext_tsk");		/* ߂ʒuext_tskɐݒ */
	Asm("pushn %r0");
	Asm("ld.w %%r6, %0": : "r"(runtsk->tinib->exinf));
	set_pc(runtsk->tinib->task);
}

/*
 *  ^XNfBXpb`
 *
 *  dispatch̓^XNReLXgECPUbNԂŌĂяoB
 *  exit_and_dispatchlAJ[lNɑΉ邽
 *  ^XNReLXgECPUbNԂ̌ĂяoɂΉ
 *  ĂB
 */
void
dispatch(void)
{
	TCB * task;

	Asm("pushn %r3");
	task = runtsk;
	task->tskctxb.sp = get_sp();
	task->tskctxb.pc = && dispatch_1;	/* gccg@\gp */
	Asm("xjp _kernel_exit_and_dispatch");
dispatch_1:
	Asm("popn %r3");
	task = (TCB * volatile) runtsk;
	if ((task->enatex != FALSE) && (task->texptn != 0)) {
		Asm("xjp _kernel_calltex");	/* OnhN	*/
	}
}

void
exit_and_dispatch(void)
{
	register UW	ulPsr;

	lock_cpu();			/* CPUbN	*/
	runtsk = schedtsk;
	if (runtsk != NULL) {
		set_sp(runtsk->tskctxb.sp);
		set_pc(runtsk->tskctxb.pc);
	}

	set_sp(STACKTOP);			/* s\ȃ^XNȂꍇ	*/
	ulPsr = get_psr();			/* 荞݂ăCxg	*/
	ulPsr |= S1C33_PSR_FLAG_IE;	/* ҂					*/
	set_psr(ulPsr);
	unlock_cpu();

	while (1) {
		Asm("halt");
	}
}

/*
 *  ݃nh/CPUOnho
 */
void
ret_int(void)
{
	static	TCB * task;

	reqflg = FALSE;
	task = runtsk;

	if (task == NULL) {			/* AChփWv */
		Asm("xjp _kernel_exit_and_dispatch");
	}

	if ((enadsp != FALSE) && (task != schedtsk)) {
#ifndef	__c33adv
		Asm("pushn %r1");
#endif	/* __c33adv */
		task->tskctxb.sp = get_sp();
		task->tskctxb.pc = && ret_int_2;/* gccg@\gp */
						/* fBXpb`փWv */
		Asm("xjp _kernel_exit_and_dispatch");
ret_int_2:
#ifndef	__c33adv
		Asm("popn %r1");
#endif	/* __c33adv */
	}
	task = (TCB * volatile) runtsk;
	if ((task->enatex != FALSE) && (task->texptn != 0)) {
		call_texrtn();			/* OnhN	*/
	}
#ifdef	__c33adv
	Asm("pops %sor");
#else	/* __c33adv */
	Asm("ld.w %alr, %r1");
	Asm("ld.w %ahr, %r0");
#endif	/* __c33adv */

#if TPS_DAREA_CNT == 4				/* f[^GA|C^	*/
	Asm("popn %r11");			/* pops		*/
#elif TPS_DAREA_CNT == 3
	Asm("popn %r12");
#elif TPS_DAREA_CNT == 2
	Asm("popn %r13");
#elif TPS_DAREA_CNT == 1
	Asm("popn %r14");
#else
	Asm("popn %r15");
#endif /* TPS_DAREA */

	Asm("reti");				/* CPUbNԂ͕A	*/
						/* ^XÑT[rXR[	*/
						/* ^[鎞ɉ	*/
}


/*
 *  ݃xύX
 */
ER
chg_ilv(ILEVNO ilevno)
{
	UW	ulPsr;
	ER	ercd;

	LOG_CHG_ILV_ENTER(ilevno)
	CHECK_TSKCTX_UNL();
	if(ilevno > TPS_INTLEV_MAX){
		ercd = E_PAR;
	} else {
		ulPsr = get_psr();			/* ݂PSRl擾	*/
		ulPsr = (ulPsr & ~S1C33_PSR_MASK_IL) | (ilevno << 8);
		set_psr(ulPsr);				/* PSRlXV		*/
		ercd = E_OK;
	}
exit:
	LOG_CHG_ILV_LEAVE(ercd)				/* Set New IL		*/
	return(ercd);
}

/*
 *  ݃x擾
 */
ER
get_ilv(ILEVNO *p_ilevno)
{
	UW	ulPsr;
	ER	ercd;

	LOG_GET_ILV_ENTER(p_ilevno)
	CHECK_TSKCTX_UNL();
	if(p_ilevno == NULL){
		ercd = E_PAR;
	} else {
		ulPsr = get_psr();			/* ݂̊݃x擾 */
		*p_ilevno = (ulPsr & S1C33_PSR_MASK_IL) >> 8;
		ercd = E_OK;
	}
exit:
	LOG_GET_ILV_LEAVE(ercd, piLevno)
	return(ercd);
}

#ifndef __c33pe
/*
 *  ݔ
 */
ER
ena_int(INTNO intno)
{
	INT	iOffset, iBitFlag;

	iOffset = get_Offset(intno);			/* WX^ʒu擾 */
	iBitFlag = get_BitFlag(intno);

	if(iOffset == E_PAR || iBitFlag == E_PAR){
		return (E_PAR);
	}
							/* 荞݂ */
	(*(s1c33Intc_t *) S1C33_INTC_BASE).bIntEnable[iOffset] |= (UB)iBitFlag;

	return (E_OK);
}

/*
 *  ݔ֎~
 */
ER
dis_int(INTNO intno)
{
	INT	iOffset, iBitFlag;

	iOffset = get_Offset(intno);			/* WX^ʒu擾  */
	iBitFlag = get_BitFlag(intno);

	if(iOffset == E_PAR || iBitFlag == E_PAR){
		return (E_PAR);
	}
							/* 荞݂֎~ */
	(*(s1c33Intc_t *) S1C33_INTC_BASE).bIntEnable[iOffset] &= ~((UB)iBitFlag);

	return (E_OK);
}

/*
 *  ݔvNA
 */
ER
clr_int(INTNO intno)
{
	INT	iOffset, iBitFlag;

	iOffset = get_Offset(intno);			/* WX^ʒu擾 */
	iBitFlag = get_BitFlag(intno);

	if(iOffset == E_PAR || iBitFlag == E_PAR){
		return (E_PAR);
	}
#ifdef	__c33adv
	if(intno > S1C33_INHNO_SERIAL3TX){		/* /֎~WX^Ɨv    */
		iOffset -= 0x0d;			/* tOWX^̃ItZbg */
	}						/* ʒuvȂ       */
#endif /* __c33adv */
							/* 荞ݗvNA */
	(*(s1c33Intc_t *) S1C33_INTC_BASE).bIntFactor[iOffset] = ((UB)iBitFlag);

	return (E_OK);
}
#else  /* __c33pe */
#error "*_int() are valid for C33 Standard/Advanced macro."
#endif /* __c33pe */
