/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: start.S,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *	J[lp̃X^[gAbvW[iPowerPCpj
 *	
 *	WX^̊蓖
 *		r1@ FX^bN|C^
 *		SPRG0F݁^CPUOlXgJE^
 *		SPRG1Fint_table
 *			@@ݗp[xN^e[u̐擪AhX
 *		SPRG2Fexc_table
 *			@@CPUOp[xN^e[u̐擪AhX
 */

#define	_MACRO_ONLY
#include <t_config.h>

	.text
	.globl start
	.globl start_1
start:
	/*
	 *  vZbT[hƃX^bN|C^̏
	 *@@ZbgMSȐl̂܂܂ł悯΁A
	 *@@INIT_MSR͒`ȂĂ悢B
	 */
#ifdef INIT_MSR
	LI32(r3, INIT_MSR)		/*  MSȐ  */
	mtmsr	r3
#endif	/*  INIT_MSR  */
	
	/*
	 * ^XNReLXg̃X^bNSTACKTOPɏ
	 * STACKTOṔAsys_config.hŒ`
	 * R[OERxV̊֌W8oCg炵Ă
	 */
	LI32(sp, STACKTOP - STACK_MARGIN)
	
	/*  ݁^CPUOlXgJE^̏  */
	li	r5, 1
	mtspr	SPRG0, r5
	
	/*  ݗp[xN^e[u̐擪AhX  */
	LI32(r6, int_table)
	mtspr	SPRG1, r6
	
	/*  CPUOp[xN^e[u̐擪AhX  */
	LI32(r7, exc_table)
	mtspr	SPRG2, r7
	
	/*
	 *  hardware_init_hook ̌ďoi0 łȂꍇj
	 *
	 *  n[hEFAˑɕKvȏꍇ́C
	 *  hardware_init_hook Ƃ֐pӂ΂悢D
	 *  ̓IɂROM̍ہARAMgp\ɂ邽߂
	 *  oXRg[̏sB
	 *  sys_support.S  hardware_init_hook `Ă
	 *  D
	 */
	LI32(r8, hardware_init_hook)
	mtctr	r8
	cmpwi	crf0, r8, 0
	bnectrl

	/*
	 *  bssZNṼNA
	 */
start_1:
	LI32(r5, __bss_start)
	LI32(r6, _end)
	cmpw	crf0, r5, r6
	beq	start_3
	li	r0, 0
	subi	r5, r5, 4
	subi	r6, r6, 4
start_2:
	stwu	r0, 4(r5)	/*  r5̍XV1߂Ŏs  */
	cmpw	crf0, r5, r6
	blt	start_2	

	/*
	 *  dataZNV̏iROMΉj
	 *
	 *  __idata_start  __idata_end ܂łC__data_start ȍ~
	 *  Rs[D
	 */
start_3:
	LI32(r7, __idata_start)
	LI32(r8, __idata_end)
	cmpw	crf0, r7, r8
	beq	start_5
	LI32(r9, __data_start)
	subi	r7, r7, 4	/*  lwzu߂g-4Ă  */
	subi	r8, r8, 4
	subi	r9, r9, 4
start_4:
	lwzu	r10, 4(r7)	/*  r7̍XV1߂Ŏs  */
	stwu	r10, 4(r9)	/*  r9̍XV1߂Ŏs  */
	cmpw	crf0, r7, r8
	blt	start_4

	/*
	 *  software_init_hook ďoi0 łȂꍇj
	 *
	 *  \tgEFAiɃCujɈˑĕKvȏ
	 *  ꍇ́Csoftware_init_hook Ƃ֐pӂ
	 *  悢D
	 */
start_5:
	LI32(r4, software_init_hook)
	mtctr	r4
	cmpwi	crf0, r4, 0
	bnectrl

	/*
	 *  J[lND
	 */
start_6:
	LI32(r5, kernel_start)
	mtctr	r5
	bctr

/*  end of file  */
