/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_config.c,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *	^[QbgVXeˑW[iMPC860T TB6102Spj
 *@@@@@J[lŎgp`
 *@@@@@@C֐̎
 */

#include "jsp_kernel.h"
#include <mpc860_sil.h>

/*
 *  ݔɃX^bNɑҔꂽԂIPM̃f[^\
 *    4oCgEێ邽߁A_~[̈悪
 */
typedef struct ipm_stack {
	UH	ipm;
	UH	dummy;
} IPM_STACK;

/*
 *  ݃}XNp[xN^e[u
 *	ipm_tablê$(CPU)Ƃ̃C^[tF[XɊ܂܂Ȃ
 *@@@idefine_ipmɂABĂj
 */
IPM ipm_table[TMAX_EXCNO];

/*
 *  SILgpƂ̃O@\
 */
#ifdef SIL_DEBUG

BOOL sil_debug_on = FALSE;
char sil_buffer[SIL_BUFFER_SIZE];
int sil_pos = -1;
UW sil_log_id = 0;

#endif	/* SIL_DEBUG */

/*
 *  ^[QbgVXeˑ̏
 */
void
sys_initialize()
{
    	INHNO j;
	
	/*
	 *  ʐMvZbTCPM̏
	 */
	
	/*  ZbgER}h̔s  */
    	mpc860_wrh_mem(CPCR, CPCR_RST | CPCR_FLG);
	
	/*
	 *  ݃Rg[̏
	 *@@IRLFSIUɑ΂銄݃x
	 *@@IEN=1FCPM݃Cl[u
	 */
	mpc860_wrw_mem(CICR, CICR_IRL0 | CICR_IEN);

	/*  IPM̏FCPM݂̋  */
	mpc860_wrh_mem(SIMASK, ENABLE_CPM);


	/*
	 *  f[^̏
	 */

    	/* IPMe[ȕ */
    	for( j = 0; j < TMAX_EXCNO; j++ ) {
        	ipm_table[j] = DEFAULT_IPM;
    	}
    	
    	/*  CPM݂IPMݒ  */
    	ipm_table[INHNO_CPM] = IPM_CPM;
	
	/*
	 *  vZbTʂ̂߂̕ϐ̏
	 */
	/*    */
}

/*
 *  ^[QbgVXȅI
 */
void
sys_exit()
{
	tb6102s_exit();
}

/*
 *  ^[QbgVXe̕o
 */
void
sys_putc(char c)
{
	if (c == '\n') {
		tb6102s_putc('\r');
	}
	tb6102s_putc(c);
}

/*
 * o^ĂȂݔ̃Oo
 * @@}NPROC_ICU̒ŌĂяo
 * @@֐̌^̓vZbTɌ߂ėǂ
 *
 *     MPC860ł͊݃Rg[JXP[hڑĂ邽߁A
 *@@ e݃Rg[ɐp̊֐pӂB
 *
 */

/*  SIU݁iCPM݈ȊOj  */
void no_reg_SIU_interrupt(INHNO intno, UW *sp)
{
    syslog(LOG_EMERG, "SIU interrupt error occurs.");
    syslog(LOG_EMERG, "Interrupt No.=%d", intno);
    syslog(LOG_EMERG, "IPM=0x%04x", ((IPM_STACK *)sp)->ipm);

    /*  
     *  X^bÑf[^̕\
     *    ݃}XNX^bNɐςł̂
     *@  ̕AXLbv
     */
    ++sp;
    syslog_data_on_stack((EXCSTACK *)sp);
    
    while(1);
}

/*  CPM  */
void no_reg_CPM_interrupt(INHNO intno, UW *sp)
{
    syslog(LOG_EMERG, "CPM interrupt error occurs.");
    syslog(LOG_EMERG, "Interrupt No.=%d(total %d)", 
           intno, intno + TMAX_SIU_INTNO);
    syslog(LOG_EMERG, "IPM=0x%04x", ((IPM_STACK *)sp)->ipm);

    /*  
     *  X^bÑf[^̕\
     *    ݃}XNX^bNɐςł̂
     *@  ̕AXLbv
     */
    ++sp;
    syslog_data_on_stack((EXCSTACK *)sp);
    
    while(1);
}

/*  end of file  */
