/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_serial.h,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *@@VAI/OfoCXiSIOjhCoiMPC860Tpj
 *@@@@MPC860TVAE}l[WgRg[SMC1gp
 *
 *@@@@smc.{c,h}hw_serial.h̊̕
 *@@@@@@Esmc.{c,h}FVAfoCXɈˑ镔̂݋Lq
 *@@@@@@Ehw_serial.hFVAfoCXȊOɋN鎖
 *@@@@ @@@@@@@@@hw_serial.hɋLq
 *@@@@@@@@@@@@@@݃Rg[ˑȂ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#ifndef _MACRO_ONLY
#include <mpc860_smc.h>
#endif /* _MACRO_ONLY */

/*
 *  SIO̊݃nh̃xN^ԍiMʁj
 */
#define INHNO_SERIAL	INTNO_SMC1

/*
 *@SIU猩CPM݃\[X̊݃x͈܂Ƃ߂ɂȂA
 *@CPMł̊݃x̓n[hEFAɂ茈肳B
 *@̂߁ASMC1ŗLIPM͗pӂĂȂB
 */

#ifndef _MACRO_ONLY

/*
 *  SIOhCȍ[`
 */
#define	sio_initialize	smc_initialize

/*
 *  VAI/O|[g̃I[v
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;

	/*
	 *  foCXˑ̃I[vD
	 */
	siopcb = smc_opn_por(siopid, exinf);

    	/*
    	 *  CPM݃Rg[̐ݒ
    	 *  @CPM݃RtBM[VEWX^CICR
    	 *  @ݒCPȔōsĂƂ
    	 *  @i݃Rg[ˑj
    	 *  @
    	 *  @CPMł̊ݏʂ͌Œ肳ĂB
    	 *  @iSCCj
    	 */
    	mpc860_orw_mem(CIMR, CIMR_SMC1);	/*  SMC1݂  */

	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  foCXˑ̃N[YD
	 */
	smc_cls_por(siopcb);

	if (!smc_openflag()) {
		/*  ׂẴ|[gN[YĂ  */
		/*  VAfoCXւ̃NbN~  */
	}

    	/*
    	 *  CPM݃Rg[̐ݒ
    	 *  @i݃Rg[ˑj
    	 */
    	mpc860_andw_mem(CIMR, ~CIMR_SMC1);	/*  SMC1݂֎~  */
}

/*
 *  SIO̊݃nhiMʁj
 */
#define	sio_handler	smc_isr

/*
 *  VAI/O|[gւ̕M
 */
#define	sio_snd_chr	smc_snd_chr

/*
 *  VAI/O|[g̕M
 */
#define	sio_rcv_chr	smc_rcv_chr

/*
 *  VAI/O|[g̃R[obN̋
 */
#define	sio_ena_cbr	smc_ena_cbr

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
#define	sio_dis_cbr	smc_dis_cbr

/*
 *  VAI/O|[g̑M\R[obN
 *  @@jsp/systask/serial.cɂ̂l[Ă
 *  @@ȋOQƁj
 */
#define	sio_ierdy_snd	smc_ierdy_snd

/*
 *  VAI/O|[g̎MʒmR[obN
 *  @@jsp/systask/serial.cɂ̂l[Ă
 *  @@ȋOQƁj
 */
#define	sio_ierdy_rcv	smc_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
/*  end of file  */
