/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_insn.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *	vZbT̓ꖽ߂̃CC֐`iPowerPCpj
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/*
 *  䃌WX^̑֐
 */

/*
 *  }VXe[^XWX^iMSRǰݒl̓Ǐo
 */
Inline UW
current_msr(void)
{
	UW msr;
	Asm("mfmsr %0" : "=r"(msr));
	return(msr);
}


/*
 *  }VXe[^XWX^iMSRǰݒl̕ύX
 */
Inline void
set_msr(UW msr)
{
	Asm("mtmsr %0" : : "r"(msr) );
}


/*
 *  NMIׂĂ݂̊֎~
 */
Inline void
disint(void)
{
#if !defined(IBM_PPC_EMB_ENV)
	/*  
	 *   IWiPowerPCA[LeN`̏ꍇ
	 *   @@g[MPCV[YAIPM PowerPC6xx/7xxV[Y
	 *   @@ɊYB
	 */   
	UW msr;
	
	msr = current_msr();
	msr |= MSR_EE;
	msr ^= MSR_EE;
	set_msr(msr);

#else	/*  IBM_PPC_EMB_ENV  */
	/*  
	 *   The IBM PowerPC Embedded Environment̏ꍇ
	 *   @IBMnPowerPC40xV[YΉ
	 *   @@wrteei߂ŒEErbgNAłB
	 */   
	Asm("wrteei 0" : );	/*  MSR.EE0  */

#endif	/*  IBM_PPC_EMB_ENV  */
}


/*
 *  ݂
 */
Inline void
enaint()
{
#if !defined(IBM_PPC_EMB_ENV)
	/*  
	 *   IWiPowerPCA[LeN`̏ꍇ
	 *   @@g[MPCV[YAIPM PowerPC6xx/7xxV[Y
	 *   @@ɊYB
	 */   
	UW msr;
	
	msr = current_msr();
	msr |= MSR_EE;
	set_msr(msr);

#else	/*  IBM_PPC_EMB_ENV  */
	/*  
	 *   The IBM PowerPC Embedded Environment̏ꍇ
	 *   @IBMnPowerPC40xV[YΉ
	 *   @@wrteei߂ŒEErbgZbgłB
	 */   
	Asm("wrteei 1" : );	/*  MSR.EE1  */

#endif	/*  IBM_PPC_EMB_ENV  */
}


/*
 *  XyVEp[pXEXWX^iSPRǰݒl̓Ǐo
 *     no :WX^ԍ
 *     dst:ǂݏoli[ϐ
 */

#define _current_spr(no, dst)	Asm("mfspr %0," #no : "=r"(dst))
#define current_spr(no, dst)	_current_spr(no, dst)


/*
 *  XyVEp[pXEXWX^iSPRǰݒl̕ύX
 *     no :WX^ԍ
 *     src:ݒ肷l
 */
#define set_spr(no, src)	_set_spr(no, src)
#define _set_spr(no, src)	Asm("mtspr "#no", %1" : : "r"(src) )

/*
 *  SPRG0̌ݒl̓Ǐo
 */
Inline UW
current_sprg0()
{
    UW sprg0;
    
    current_spr(SPRG0, sprg0);	/*  sprg0  SPRG0  */
    return(sprg0);
}



/*
 *  fBL[T[`̂߂̃rbg}bvT[`֐
 *
 *@@@ˑŗpӂ֐𗘗p̂
 *@@CPU_BITMAP_SEARCH}N͒`Ȃ
 */


#endif /* _CPU_INSN_H_ */
/*  end of file  */
