/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2005 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN    
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: nios2.c,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 * Nios2 WytFphCo
 */
#include <s_services.h>
#include <nios2.h>


/*
 * UART p ȈՃhCo
 */

/*                                                                       
 * VAI/O|[gubN                                         
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {{}};

/*                                                                      
 *  VAI/O|[gǗubÑGA                                
 */
SIOPCB  siopcb_table[TNUM_SIOP];

/*                                                                          
 *  VAI/O|[gIDǗubNo߂̃}N                  
 */
#define INDEX_SIOP(siopid)  ((UINT)((siopid) - 1))
#define get_siopcb(siopid)  (&(siopcb_table[INDEX_SIOP(siopid)]))

#ifdef USE_JTAG_UART
/*
 *  JTAG_UART ̓Xe[^Xƃf[^𓯎Ɏ擾邽߁CXe[^X
 *  `FbNƃf[^ǂݍł܂D̂߁Cuart_getready()
 *  s̃f[^D  
 */ 
UB jtag_uart_buf = -1;
#endif /* USE_JTAG_UART */

/*
 * M?                                                       
 */
Inline BOOL
uart_getready(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART
	return((sil_rew_mem((VP)UART_STATUS) &
			UART_STATUS_RRDY) != 0);
#else
	UW tmp = sil_rew_mem((VP)JTAG_UART_DATA);
	jtag_uart_buf = (UB)tmp;	
	return ((tmp & JTAG_UART_DATA_RVALID) != 0);
#endif /* USE_JTAG_UART	*/	
}

/*                                                                             
 * 𑗐Mł邩?                                                         
 */
Inline BOOL
uart_putready(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART		
	return((sil_rew_mem((VP)UART_STATUS) & UART_STATUS_TRDY) != 0);
#else
	return((sil_rew_mem(
		(VP)JTAG_UART_CONTROL) & JTAG_UART_CONTROL_WSAPCE) > 0);
#endif /* USE_JTAG_UART	*/
}

/*                                                                             
 *  M̎o                                                     
 */
Inline UB
uart_getchar(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART
	return((UB)(sil_rew_mem((VP)UART_RXDATA)));
#else
	return((UB)(sil_rew_mem((VP)JTAG_UART_DATA)));
#endif /* USE_JTAG_UART	*/
}

/*                                                                            
 *  M镶̏                                                    
 */
Inline void
uart_putchar(SIOPCB *siopcb, UB c)
{
#ifndef USE_JTAG_UART
	sil_wrw_mem((VP)UART_TXDATA, c);
#else
	sil_wrw_mem((VP)JTAG_UART_DATA,c);
#endif /* USE_JTAG_UART	*/
}

/*
 * M֐
 */
/*                                                                             
 *  M݋                                                             
 */
Inline void
uart_enable_send(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART
	sil_wrw_mem((VP)UART_CONTROL,
				sil_rew_mem((VP)UART_CONTROL)|UART_CONTROL_ITRD);
#else
	sil_wrw_mem((VP)JTAG_UART_CONTROL,
				sil_rew_mem((VP)JTAG_UART_CONTROL)|JTAG_UART_CONTROL_WIE);
#endif /* USE_JTAG_UART	*/	
}

/*                                                                             
 *  M݋֎~                                                             
 */
Inline void
uart_disable_send(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART
	sil_wrw_mem((VP)UART_CONTROL,
				sil_rew_mem((VP)UART_CONTROL)&~UART_CONTROL_ITRD);
#else
	sil_wrw_mem((VP)JTAG_UART_CONTROL,
				sil_rew_mem((VP)JTAG_UART_CONTROL)&~JTAG_UART_CONTROL_WIE);
#endif /* USE_JTAG_UART	*/
}

/*
 * M֐
 */
/*                                                                             
 *  M݋                                                             
 */
Inline void
uart_enable_rcv(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART
	sil_wrw_mem((VP)UART_CONTROL,
				sil_rew_mem((VP)UART_CONTROL)|UART_STATUS_RRDY);
#else
	sil_wrw_mem((VP)JTAG_UART_CONTROL,
				sil_rew_mem((VP)JTAG_UART_CONTROL)|JTAG_UART_CONTROL_RIE);
#endif /* USE_JTAG_UART	*/
}

/*                                                                             
 *  M݋֎~                                                             
 */
Inline void
uart_disable_rcv(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART	
	sil_wrw_mem((VP)UART_CONTROL,
				sil_rew_mem((VP)UART_CONTROL)&~UART_STATUS_RRDY);
#else
	sil_wrw_mem((VP)JTAG_UART_CONTROL,
				sil_rew_mem((VP)JTAG_UART_CONTROL)&~JTAG_UART_CONTROL_RIE);
#endif /* USE_JTAG_UART	*/	
}


/*                                                                             
 *  SIOhCȍ[`                                                
 *  1|[gȂ߁C܂Ӗ͂Ȃ                                      
 */
void
uart_initialize()
{
    SIOPCB  *siopcb;
    UINT    i;

    /*                                                                         
     *  VAI/O|[gǗubN̏                                  
     */
    for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
        siopcb->siopinib = &(siopinib_table[i]);
        siopcb->openflag = FALSE;
        siopcb->sendflag = FALSE;
    }
}


SIOPCB   *
uart_opn_por(ID siopid, VP_INT exinf){

    SIOPCB      *siopcb;
    const SIOPINIB  *siopinib;

    siopcb = get_siopcb(siopid);
    siopinib = siopcb->siopinib;

#ifndef USE_JTAG_UART		
//    sil_wrw_mem(UART_DIVISOR, UART_DIVISOR_VAL);
    sil_wrw_mem((VP)UART_STATUS, 0x00);
    
    /*
     *  M荞݋
     */
    sil_wrw_mem((VP)UART_CONTROL, UART_STATUS_RRDY);
#else
	sil_wrw_mem((VP)JTAG_UART_CONTROL,JTAG_UART_CONTROL_RIE);
#endif /* USE_JTAG_UART	*/
	
    siopcb->exinf = exinf;
    siopcb->getready = siopcb->putready = FALSE;
    siopcb->openflag = TRUE;

    return(siopcb);
}


void
uart_cls_por(SIOPCB *siopcb){
#ifndef USE_JTAG_UART	
    /* ݋֎~ */
    sil_wrw_mem((VP)UART_CONTROL, 0x00);
#else
	sil_wrw_mem((VP)JTAG_UART_CONTROL,0x00);
#endif /* USE_JTAG_UART	*/		
    siopcb->openflag = FALSE;
    siopcb->sendflag = FALSE;
}



/*                                                                             
 *  VAI/O|[gւ̕M                                            
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, INT chr)
{
    if(uart_putready(siopcb)){
        uart_putchar(siopcb, (UB) chr);
        return(TRUE);
    }
    return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART
	if (uart_getready(siopcb)) {
		return((INT)(UB) uart_getchar(siopcb));
	}
	return(-1);
#else
	UB tmp;
	
	if (jtag_uart_buf != -1) {
		tmp = jtag_uart_buf;
		jtag_uart_buf = -1;
		return tmp;
	}
	return(-1);
#endif /* USE_JTAG_UART	*/	
}


/*
 *  VAI/O|[g̃R[obN̋
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
      case SIO_ERDY_SND:
        uart_enable_send(siopcb);
        break;
      case SIO_ERDY_RCV:
        uart_enable_rcv(siopcb);
        break;
    }

}


/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
      case SIO_ERDY_SND:
        uart_disable_send(siopcb);
        break;
      case SIO_ERDY_RCV:
        uart_disable_rcv(siopcb);
        break;
    }
}


/*                                                                            
 *  VAI/O|[gɑ΂銄ݏ                                       
 */
static void
uart_isr_siop(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        /*
         *  MʒmR[obN[`ĂяoD
         */
        uart_ierdy_rcv(siopcb->exinf);
    }

    if (uart_putready(siopcb)) {
        /*
         *  M\R[obN[`ĂяoD
         */
        uart_ierdy_snd(siopcb->exinf);
    }
}


/*                                                                             
 *  SIO̊݃T[rX[`                                                
 */
void
uart_isr()
{
    if (siopcb_table[0].openflag) {
        uart_isr_siop(&(siopcb_table[0]));
    }
}

