/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_insn.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

#include <nios2.h>

Inline UW
current_status(void)
{
    UW status;
    Asm("rdctl %0, status" : "=r" (status));
    return(status);
}

Inline UW
current_estatus(void)
{
    UW status;
    Asm("rdctl %0, estatus" : "=r" (status));
    return(status);
}

Inline UW
current_bstatus(void)
{
    UW status;
    Asm("rdctl %0, bstatus" : "=r" (status));
    return(status);
}

Inline UW
current_ipending(void)
{
    UW status;
    Asm("rdctl %0, ipending" : "=r" (status));
    return(status);
}

Inline UW
current_ienable(void)
{
    UW status;
    Asm("rdctl %0, ienable" : "=r" (status));
    return(status);
}

Inline void
set_status(UW status)
{
    Asm("wrctl status, %0" :: "r" (status));
}

Inline void
set_ienable(UW ienable)
{
    Asm("wrctl ienable, %0" :: "r" (ienable));
}

Inline void
disint(void)
{
    set_status(current_status() & ~STATUS_PIE);
}

Inline void
enaint()
{
    set_status(current_status() | STATUS_PIE);    
}

#endif /* _CPU_INSN_H_ */
