/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN  
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.c,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *  vZbTˑW[iNios2pj
 */
#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include <nios2.h>

/*
 * 荞݃nh/rbg}XNe[u
 */
FP  int_handler_table[MAX_INT_NUM];
UW  int_bit_table[MAX_INT_NUM];

/*
 * CPUOnhe[u
 */
FP	exc_handler_table[MAX_EXC_NUM]; 

/*
 * 荞݂̃lXg񐔂̃JEg
 * J[lN̓^XNƗƂ݂Ȃ1ŏ
 */
UW interrupt_count = 1;

/*
 *  vZbTˑ̏
 */
void
cpu_initialize()
{
    int i;
    
    /*
     * int_handler_table[],int_plevel_table[]̏
     * o^̊ݔcpu_interrup()Ăяo悤
     * no_reg_interrup()o^
     */
    for(i = 0; i < MAX_INT_NUM; i++){
        int_handler_table[i] = no_reg_interrupt;
        int_bit_table[i]  = 1 << i; /* rbgp^[̐ */
    }

    /*
     *  CPUOnhe[u
     */
    for(i = 0; i < MAX_EXC_NUM; i++){
        exc_handler_table[i] = no_reg_exception; 
    }
}

/*
 *  vZbTˑ̏I
 *  ݋֎~
 */
void
cpu_terminate()
{
    disint();
}


/*
 * ݂̋/֎~
 */
SYSCALL ER
ena_int(INTNO intno){
    set_ienable((1 << intno) | current_ienable()); 
}

SYSCALL ER
dis_int(INTNO intno){
    set_ienable(~(1 << intno) & current_ienable());    
}


/*
 * o^݂̊ꍇɌĂяo
 */
void
no_reg_interrupt(void)
{
    syslog(LOG_EMERG, "Unregisted Interrupt Occur!");
    while(1);
}

/*
 * o^̗OꍇɌĂяo
 */
void
no_reg_exception(void)
{
    syslog(LOG_EMERG, "Unregisted Exception Occur!");
    while(1);    
}

/*
 * ݗv̔Ɗ݃nȟĂяo
 */
void
int_handler_call(){
    UW status;
    UW mask;
    int i;
    
    interrupt_count++;
    status = current_ipending();
    for(i = 0; i < 32; i++){
        if((status & (1 << i)) != 0x00){
            mask = current_ienable();
            set_ienable(~int_bit_table[i] & mask);
            
            enaint();
            (int_handler_table[i])();
            disint();
            
            set_ienable(mask);
            break;
        }
    }
    interrupt_count--;    
}

/*
 *  O̔CPUOnȟĂяo
 *  ݂͖ߗÔ݂T|[g 
 */
void
exc_handler_call(VP p_excinf){
    interrupt_count++;

    enaint();
    (exc_handler_table[0])(p_excinf);
    disint();
    
    interrupt_count--;    
}
