/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _PIC_ICU_H_
#define _PIC_ICU_H_

#ifndef _MACRO_ONLY
#include <sil.h>
#endif /* _MACRO_ONLY */

#include <rte_vr5500_cb.h>	/* ICU_BASE_ADDR */

/*
 *  ݃Rg[(Programable Interrupt Controler)֌W̒`
 */

/*  ݔԍ̒`i0-7mips3.hŎgpB8ȍ~w肷Bj */
#define INTNO_TIMER0	 8	/*  ^C}O      */
#define INTNO_SERIAL0	 9	/*  VAO    */
#define INTNO_GBUS	10	/*  GBUS-INT0-    */
#define	INTNO_BUS_ERR	11	/*  BUS_ERROR     */
#define	INTNO_TIMER1	12	/*  ^C}P      */
#define INTNO_SERIAL1	13	/*  VAP    */
#define INTNO_PARALEL	14	/*  p      */
#define INTNO_DMAC	15	/*  DMAC_INTREQ-  */

/*  ݃Rg[Ǘ銄݂̖{  */
#define TMAX_ICU_INTNO	8u

/*  ݃Rg[̃WX^̃AhX`  */
/* ȉxxx_offset́AAZuŎgB */
#define INT0M_offset	0x00
#define INT1M_offset	0x10
#define INTR_offset	0x20
#define INTEN_offset	0x30

#define ICU_INT0M	INT0M_offset
#define ICU_INT1M	INT1M_offset
#define ICU_INTR	INTR_offset
#define ICU_INTEN	INTEN_offset

/*  ݗvrbgp^[ (LAAZułpĂB) */
#define TIMER0		BIT0
#define SERIAL0		BIT1
#define GBUS		BIT2
#define	BUS_ERR		BIT3
#define	TIMER1		BIT4
#define SERIAL1		BIT5
#define PARALEL		BIT6
#define DMAC		BIT7

/* ICŨWX^ANZXp̊֐  */
#define icu_reb( addr )		sil_reb_mem( (VP)(ICU_BASE_ADDR + addr) )
#define icu_wrb( addr, val )	sil_wrb_mem( (VP)(ICU_BASE_ADDR + addr), val )

#define icu_orb( mem, val )	icu_wrb( mem, icu_reb( mem ) | val )
#define icu_andb( mem, val )	icu_wrb( mem, icu_reb( mem ) & val )

/*
 *  ݃Rg[̊݃}XN֌W
 */

/*  \ICU_IPM̃ItZbg߂邽߂̃}Nimakeoffset.cŗpj
    ȂÃ}NŒ`ĺAɗpĂȂB*/
#define OFFSET_DEF_ICU_IPM	OFFSET_DEF(ICU_IPM, int1m)

/*  ݃Rg[ɐݒ\Ȋ݃}XNrbgp^[iōlj*/
#define MAX_ICU_IPM  0xff

/*  ݃Rg[ɐݒ肷銄݃}XÑ`FbN  */
#define CHECK_ICU_IPM(ipm)						       \
		CHECK_PAR( 0 < (ipm.int0m) && (ipm.int0m) <= MAX_ICU_IPM );    \
		CHECK_PAR( 0 < (ipm.int1m) && (ipm.int1m) <= MAX_ICU_IPM )

#ifndef _MACRO_ONLY

/*  ݃Rg[ɑ΂銄݃}XN̋[e[u  */
extern ICU_IPM icu_intmask_table[];

/*  ݃Rg[intmaske[u̐ݒ  */
Inline void icu_set_ilv(INTNO intno, ICU_IPM *ipm) {
	/* CHECK_ICU_IPM(ipm) ́Aʃ[`Ŏsς */
	icu_intmask_table[intno].int0m = ipm->int0m;
	icu_intmask_table[intno].int1m = ipm->int1m;
}

/*  荞݃Rg[̃}XNݒ  */
Inline void icu_set_ipm(ICU_IPM *ipm) {
	/* CHECK_ICU_IPM(ipm) ́Aʃ[`Ŏsς */
	icu_wrb( (VP) ICU_INT0M, ipm->int0m );
	icu_wrb( (VP) ICU_INT1M, ipm->int1m );
}

/*  荞݃Rg[̃}XN擾  */
Inline void icu_get_ipm(ICU_IPM *ipm) {
	ipm->int0m = icu_reb( (VP) ICU_INT0M );
	ipm->int1m = icu_reb( (VP) ICU_INT1M );
}

#endif /* _MACRO_ONLY */

/*============================================================================*/
/*  AZu֌W  */

/*  ݋rbg̑Ҕƕ  */
/*  ݃Rg[ICUIPMX^bNɕۑ  */
/*  [hE̊֌WŁA{1oCg̃}XNł͂邯ǂA
    [hÊ߂2oCgPʂňKvB */
#define PUSH_ICU_IPM						\
	li	t1, ICU_BASE_ADDR;				\
	addi	sp, sp, -2*2;					\
	lb	t3, INT0M_offset(t1);	/* t3 = INT0M */	\
	lb	t4, INT1M_offset(t1);	/* t4 = INT1M */	\
	sh	t3, (sp);					\
	sh	t4, 2(sp)

/*  ݃Rg[ICUIPMX^bN畜  */
#define POP_ICU_IPM						\
	li	t1, ICU_BASE_ADDR;				\
	lh	t3, (sp);					\
	lh	t4, 2(sp);					\
	sb	t3, INT0M_offset(t1);	/* INT0M = t3 */	\
	sb	t4, INT1M_offset(t1);	/* INT1M = t4 */	\
	addi	sp, sp, 2*2

/*  ݃Rg[ICUIPMݒ  */
/*      t0ɊݗvԍԂŌĂ΂  */
/*      t0̓e󂵂Ă͂Ȃ  */
/*      t1ɊݗvNA̒萔Ă̂Ŕj󂵂Ă͂ȂȂB  */
#define SET_ICU_IPM								\
	la	t4, icu_intmask_table;	/*  f[^e[u̐擪AhX  */	\
	sll	t2, t0, 1;		/*  ItZbgݗvԍ~2{	\
						(}XŃA2oCg)  */		\
	li	t3, ICU_BASE_ADDR;						\
	add	t4, t4, t2;		/*  擪AhX{ItZbg  */	\
	lh	t5, (t4);		/*  t5 = INT0M:INT1M  */		\
					/*  ӁFgGfBAˑ  */	\
	sb	t5, INT0M_offset(t3);	/*  INT0M=t5̉1oCg  */		\
	srl	t6, t5, 8;							\
	sb	t6, INT1M_offset(t3);	/*  INT1M=t5̏1oCg  */

/*  foCXʏWJ}N  */
/*    ݗvt0ɓ proc_END ɔ  */
#define MAKE_PROC(device)		\
proc_##device:				\
	li	t0, INTNO_##device;	\
 	j	proc_END;		\
	nop;

/*  ݗv̔  */
/*    ݃Rg[MIPS3RAInt0ɐڑĂ  */
/*    }XÑ`FbN*/
#define PROC_INT0				\
	li      t2, ICU_BASE_ADDR;		\
	lb      t3, INTR_offset(t2);		\
	lb	t4, INT0M_offset(t2);		\
	and	t5, t3, t4;		/* INT0M ƃ}XN */	\
	beq	t5, zero, proc_END;		\
	nop;					\
						\
proc_BIT0:					\
	andi	t4, t3, TIMER0;			\
	beq	t4, zero, proc_BIT1;		\
	nop;					\
MAKE_PROC(TIMER0)				\
						\
proc_BIT1:					\
	andi	t4, t3, SERIAL0;		\
	beq	t4, zero, proc_BIT2;		\
	nop;					\
MAKE_PROC(SERIAL0)				\
						\
proc_BIT2:					\
	andi	t4, t3, GBUS;			\
	beq	t4, zero, proc_BIT3;		\
	nop;					\
MAKE_PROC(GBUS)					\
						\
proc_BIT3:					\
	andi	t4, t3, BUS_ERR;		\
	beq	t4, zero, proc_BIT4;		\
	nop;					\
MAKE_PROC(BUS_ERR)				\
						\
proc_BIT4:					\
	andi	t4, t3, TIMER1;			\
	beq	t4, zero, proc_BIT5;		\
	nop;					\
MAKE_PROC(TIMER1)				\
						\
proc_BIT5:					\
	andi	t4, t3, SERIAL1;		\
	beq	t4, zero, proc_BIT6;		\
	nop;					\
MAKE_PROC(SERIAL1)				\
						\
proc_BIT6:					\
	andi	t4, t3, PARALEL;		\
	beq	t4, zero, proc_BIT7;		\
	nop;					\
MAKE_PROC(PARALEL)				\
						\
proc_BIT7:					\
	andi	t4, t3, DMAC;			\
	beq	t4, zero, proc_END;		\
	nop;					\
MAKE_PROC(DMAC)					\
						\
proc_END:

#endif /* _PIC_ICU_H_ */
