/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

/*
 *	VAI/OfoCXiSIOjhCoiTI16PIR552pj
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <tl16pir552.h>		/* siopcb, tl16pir552_openflag */

/*
 *  SIO̊݃nh̃xN^ԍ
 */
#define INHNO_SIO1		INTNO_SERIAL0
#define INHNO_SIO2		INTNO_SERIAL1

/*
 *  SIOhCȍ[`
 */
#define	sio_initialize		tl16pir552_initialize

/*
 *  J[lNp̏ (sys_putcŗp)
 */
#define sio_init		tl16pir552_init

#ifndef _MACRO_ONLY

/*
 *  VAI/O|[g̃I[v
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	UB	mask = 0;

	/*
	 *  I[v|[g邩 openflag ɓǂłD
	 */
	openflag = tl16pir552_openflag();

	/*
	 *  foCXˑ̃I[vD
	 */
	siopcb = tl16pir552_opn_por(siopid, exinf);

	/*
	 *  VAI/O݂̊݃xݒ肵C}XND
	 */
	if (!openflag) {
		switch(siopid) {
		case 1 :	/* |[gP; VAO */
			all_set_ilv( INTNO_SERIAL0, &((IPM) IPM_SCC0) );
							/* ݃xݒ */
			mask = SERIAL0;
			break;
		case 2 :	/* |[gQ; VAP */
			all_set_ilv( INTNO_SERIAL1, &((IPM) IPM_SCC1) );
							/* ݃xݒ */
			mask = SERIAL1;
			break;
		}
		icu_orb( (VP) ICU_INT0M, mask );
							/* }XNݒ菈 */
	}

	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  foCXˑ̃N[YD
	 */
	tl16pir552_cls_por(siopcb);

	/*
	 *  VAI/O݂}XND(|[gPAQ̗)
	 */
	if (!tl16pir552_openflag) {
		icu_andb( (VP) ICU_INT0M, ~(SERIAL0 | SERIAL1) );
							/* }XNݒ菈 */
	}
}

#endif /* _MACRO_ONLY */

/*
 *  SIO̊݃nh
 */
#define	sio1_handler		tl16pir552_uart0_isr
#if TNUM_SIOP >= 2
#define sio2_handler		tl16pir552_uart1_isr
#endif /* TNUM_SIOP */

/*
 *  VAI/O|[gւ̕M
 */
#define	sio_snd_chr		tl16pir552_snd_chr

/*
 *  VAI/O|[gւ̕Mi|[Oj
 */
#define	sio_snd_chr_pol		tl16pir552_putchar_pol

/*
 *  VAI/O|[g̕M
 */
#define	sio_rcv_chr		tl16pir552_rcv_chr

/*
 *  VAI/O|[g̃R[obN̋
 */
#define	sio_ena_cbr		tl16pir552_ena_cbr

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
#define	sio_dis_cbr		tl16pir552_dis_cbr

/*
 *  VAI/O|[g̑M\R[obN
 */
#define	sio_ierdy_snd		tl16pir552_ierdy_snd

/*
 *  VAI/O|[g̎MʒmR[obN
 */
#define	sio_ierdy_rcv		tl16pir552_ierdy_rcv

#endif /* _HW_SERIAL_H_ */
