/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _VR4131_ICU_H_
#define _VR4131_ICU_H_

/*
 *  ݃Rg[(ICU)֌W̒`
 */

/*  ݔԍ̒`i0-7Ԃ mips3.h ŎgpB8Ԉȍ~w肷Bj */
/*  SYSINT1REG  */
#define INTNO_BAT        8	/*  obe  */
#define INTNO_POWER      9	/*  p[XCb`  */
#define INTNO_RTCL1     10	/*  RTCLong1  */
#define INTNO_ETIME     11	/*  ElipsedTime^C} */
#define INTNO_GIU       12	/*  GIU  */
#define INTNO_SIU       13	/*  SIU  */
#define INTNO_SOFTINT   14	/*  \tgEFA  */
#define INTNO_CLKRUN    15	/*  CLKRUN  */

/*  SYSINT2REG  */
#define INTNO_RTCL2     16	/*  RTCLong2  */
#define INTNO_LED       17	/*  LED  */
#define INTNO_TCLK      18	/*  TClockJE^  */
#define INTNO_FIR       19	/*  FIR  */
#define INTNO_DSIU      20	/*  DSIU  */
#define INTNO_PCI       21	/*  PCI  */
#define INTNO_SCU       22	/*  SCU  */
#define INTNO_CSI       23	/*  CSI  */
#define INTNO_BCU       24	/*  BCU  */

/*  ݃Rg[Ǘ銄݂̖{  */
#define TMAX_ICU_INTNO	17u

/*  ݃Rg[̃WX^̃AhX`  */
/* ȉ xxx_asmAxxx_offset ́AAZuł̗pB */
#define ICU_BASE_ADDR		0x0f000000
#define ICU_BASE_ADDR_asm	ASM_SIL( ICU_BASE_ADDR )

#define SYSINT1_offset		0x80
#define MSYSINT1_offset		0x8c
#define MDSIUINT_offset		0x96
#define SYSINT2_offset		0xa0
#define MSYSINT2_offset		0xa6

#define MSYSINT1REG	(ICU_BASE_ADDR + MSYSINT1_offset)
				/* VXe݃}XNWX^1(x1) */
#define MDSIUINTREG	(ICU_BASE_ADDR + MDSIUINT_offset)
				/* DSIU݃}XNWX^(x2)  */
#define MSYSINT2REG	(ICU_BASE_ADDR + MSYSINT2_offset)
				/* VXe݃}XNWX^2(x1) */

/*  ݗvrbgp^[ (LAAZułpĂB) */
/* MSYSINT1REG / SYSINT1REG ֌W */
#define CLKRUNINTR	BIT12	/* CLKRUN  */
#define SOFTINTR	BIT11	/* \tgEFA */
#define SIUINTR		BIT9	/* SIU  */
#define	GIUINTR		BIT8	/* GIU()  */
#define	ETIMERINTR	BIT3	/* ElapsedTime^C}  */
#define RTCL1INTR	BIT2	/* RTCLong1^C}  */
#define POWERINTR	BIT1	/* p[XCb` */
#define BATINTR		BIT0	/* obe */

/* MSYSINT2REG / SYSINT2REG ֌W */
#define BCUINTR		BIT9	/* BCU  */
#define CSIINTR		BIT8	/* CSI  */
#define SCUINTR		BIT7	/* SCU  */
#define PCIINTR		BIT6	/* PCI  */
#define DSIUINTR	BIT5	/* DSIU  */
#define FIRINTR		BIT4	/* FIR  */
#define TCLKINTR	BIT3	/* VTClockJE^  */
#define LEDINTR		BIT1	/* LED  */
#define RTCL2INTR	BIT0	/* RTCLong2  */

/* MDSIUINTREG ֌W */
#define INTDSIU  	BIT11	/* DSIU̕ω݋ */

/*
 *  ݃Rg[̊݃}XN֌W
 */

/*  \ICU_IPM̃ItZbg߂邽߂̃}Nimakeoffset.cŗpj
    ȂÃ}NŒ`ĺAɗpĂȂB*/
#define OFFSET_DEF_ICU_IPM	OFFSET_DEF(ICU_IPM, msysint2)

/*  MSYSINT1,2ɐݒ肵Ă͂Ȃrbg  */
#define NG_BIT_MSYSINT1	(BIT4 | BIT5 | BIT6 | BIT7 | BIT10 | BIT13 |BIT14 | BIT15)
#define NG_BIT_MSYSINT2	(BIT2 | BIT10 | BIT11 | BIT12 | BIT13 | BIT14 | BIT15)

/*  ݃Rg[ɐݒ肷銄݃}XÑ`FbN  */
#define CHECK_ICU_IPM(ipm)						\
		CHECK_PAR(!(ipm.msysint1 & NG_BIT_MSYSINT1));		\
		CHECK_PAR(!(ipm.msysint2 & NG_BIT_MSYSINT2))

#ifndef _MACRO_ONLY

/*  ݃Rg[ɑ΂銄݃}XN̋[e[u  */
extern ICU_IPM icu_intmask_table[];

/*  ݃Rg[intmaske[u̐ݒ  */
Inline void icu_set_ilv(INTNO intno, ICU_IPM *ipm) {
	/* CHECK_ICU_IPM(ipm) ́Aʃ[`Ŏsς */
	icu_intmask_table[intno].msysint1 = ipm->msysint1;
	icu_intmask_table[intno].msysint2 = ipm->msysint2;
}

/*  荞݃Rg[̃}XNݒ  */
Inline void icu_set_ipm(ICU_IPM *ipm) {
	/* CHECK_ICU_IPM(ipm) ́Aʃ[`Ŏsς */
	vr4131_wrh_mem( (VP) MSYSINT1REG, ipm->msysint1 );
	vr4131_wrh_mem( (VP) MSYSINT2REG, ipm->msysint2 );
}

/*  荞݃Rg[̃}XN擾  */
Inline void icu_get_ipm(ICU_IPM *ipm) {
	ipm->msysint1 = vr4131_reh_mem( (VP) MSYSINT1REG );
	ipm->msysint2 = vr4131_reh_mem( (VP) MSYSINT2REG );
}

#endif /* _MACRO_ONLY */

/*============================================================================*/
/*  AZu֌W  */

/*  ݋rbg̑Ҕƕ  */
/*  ݃Rg[ICUIPMX^bNɕۑ  */
#define PUSH_ICU_IPM						\
    li      t1, ICU_BASE_ADDR_asm;				\
    addi    sp, sp, -2*2;					\
    lh      t3, MSYSINT1_offset(t1);	/* t3 = MSYSINT1REG */	\
    lh      t4, MSYSINT2_offset(t1);	/* t4 = MSYSINT2REG */	\
    sh      t3, (sp);						\
    sh      t4, 2(sp)

/*  ݃Rg[ICUIPMX^bN畜  */
#define POP_ICU_IPM							      \
    li      t1, ICU_BASE_ADDR_asm;					      \
    lw      t3, (sp);			/* t3 = MSYSINT2REG:MSYSINT1REG */    \
					/* ӁFgGfBAˑ */    \
    sh      t3, MSYSINT1_offset(t1);	/* MSYSINT1REG = t3̉2oCg*/    \
    srl     t4, t3, 16;							      \
    sh      t4, MSYSINT2_offset(t1);	/* MSYSINT2REG = t3̏2oCg*/    \
    addi    sp, sp, 2*2

/*  ݃Rg[ICUIPMݒ  */
/*      t0ɊݗvԍԂŌĂ΂  */
/*      t0̓e󂵂Ă͂Ȃ  */
/*      t1ɊݗvNA̒萔Ă̂Ŕj󂵂Ă͂ȂȂB  */
#define SET_ICU_IPM							      \
    la      t4, icu_intmask_table;	/* f[^e[u̐擪AhX */    \
    sll     t2, t0, 2;			/* ItZbgݗvԍ~4{ */ \
    li      t3, ICU_BASE_ADDR_asm;					      \
    add     t4, t4, t2;			/* 擪AhX{ItZbg */        \
    lw      t5, (t4);			/* t5 = MSYSINT2REG:MSYSINT1REG */    \
					/* ӁFgGfBAˑ */    \
    sh      t5, MSYSINT1_offset(t3);	/* MSYSINT1REG = t5̉2oCg */   \
    srl     t6, t5, 16;							      \
    sh      t6, MSYSINT2_offset(t3)	/* MSYSINT2REG = t5̏2oCg */

/*  foCXʏWJ}N
      ݗv t0 ɓ proc_END ɔ  */
#define MAKE_PROC(device)	\
proc_##device:			\
    li      t0, INTNO_##device;	\
    j       proc_END;		\
    nop;

/*  ݗv̔  */
/*    ݃Rg[MIPS3RAInt0ɐڑĂ}XÑ`FbN */
#define PROC_INT0						\
/*  ^C}̉グ邽߁ASYSINT2REG璲ׂ  */	\
    li      t1, ICU_BASE_ADDR_asm;				\
    lh      t3, SYSINT2_offset(t1);    /* t3 = SYSINT2REG */	\
    lh      t4, MSYSINT2_offset(t1);   /* t4 = MSYSINT2REG */	\
    and     t5, t3, t4;     /*  ݗvrbgɃ}XN  */	\
    beq     t5, zero, proc_SYSINT1;				\
    andi    t6, t5, (BIT0 | BIT1 | BIT2 | BIT3 | BIT4 );	\
    beq     t6, zero, proc_SYSINT2_HIGH_5BIT;			\
								\
/*  SYSINT2REG (b0:4) ̏  */				\
    andi    t7, t5, ( RTCL2INTR | LEDINTR );			\
    beq     t7, zero, proc_SYSINT2_BIT3_4;			\
    andi    t8, t5, LEDINTR;					\
    beq     t8, zero, proc_LED;					\
MAKE_PROC(RTCL2);						\
MAKE_PROC(LED);							\
								\
proc_SYSINT2_BIT3_4:						\
    andi    t1, t5, TCLKINTR;					\
    beq     t1, zero, proc_FIR;					\
MAKE_PROC(TCLK);						\
MAKE_PROC(FIR);							\
								\
/*  SYSINT2REG (b5:9) ̏  */				\
proc_SYSINT2_HIGH_5BIT:						\
    andi    t7, t5, (DSIUINTR | PCIINTR);			\
    beq     t7, zero, proc_SYSINT2_BIT7_7;			\
    andi    t2, t5, DSIUINTR;					\
    beq     t2, zero, proc_PCI;					\
MAKE_PROC(DSIU);						\
MAKE_PROC(PCI);							\
								\
proc_SYSINT2_BIT7_7:						\
    andi    t3, t5, SCUINTR;					\
    beq     t3, zero, proc_SYSINT2_BIT8_9;			\
MAKE_PROC(SCU);							\
								\
proc_SYSINT2_BIT8_9:						\
    andi    t4, t5, CSIINTR;					\
    beq     t4, zero, proc_BCU;					\
MAKE_PROC(CSI);							\
MAKE_PROC(BCU);							\
								\
/*  SYSINT1REG̃`FbN  */					\
/*  t1ICU_BASE_ADDRԂłɗ  */		\
proc_SYSINT1:							\
    lh      t3, SYSINT1_offset(t1);	/* t3 = SYSINT1REG */	\
    lh      t4, MSYSINT1_offset(t2);	/* t4 = MSYSINT1REG */	\
    and     t5, t3, t4;     /*  ݗvrbgɃ}XN  */	\
    andi    t6, t5, 0xff;					\
    beq     t6, zero, proc_SYSINT1_HIGH_BYTE;			\
								\
/*  SYSINT1REG (ʃoCg) ̏  */				\
    andi    t7, t5, (BATINTR | POWERINTR);			\
    beq     t7, zero, proc_SYSINT1_BIT2_3;			\
    andi    t8, t5, BATINTR;					\
    beq     t8, zero, proc_POWER;				\
MAKE_PROC(BAT);							\
MAKE_PROC(POWER);						\
								\
proc_SYSINT1_BIT2_3:						\
    andi    t1, t5, ETIMERINTR;					\
    beq     t1, zero, proc_ETIME;				\
MAKE_PROC(RTCL1);						\
MAKE_PROC(ETIME);						\
								\
/*  SYSINT1REG (ʃoCg) ̏  */				\
proc_SYSINT1_HIGH_BYTE:						\
    andi    t8, t5, (GIUINTR | SIUINTR);			\
    beq     t8, zero, proc_SYSINT1_BIT11_12;			\
    andi    t9, t5, GIUINTR;					\
    beq     t9, zero, proc_SIU;					\
MAKE_PROC(GIU);							\
MAKE_PROC(SIU);							\
								\
proc_SYSINT1_BIT11_12:						\
    andi    t1, t5, SOFTINTR;					\
    beq     t1, zero, proc_CLKRUN;				\
MAKE_PROC(SOFTINT);						\
MAKE_PROC(CLKRUN);						\
								\
proc_END:

/*============================================================================*/

/* ݏɊւAݗv̔f򏈗̃VXeˑ */

	/*  ĂяoꂽƂA       */
	/*    a1ɃXe[^XWX^ */
	/*    a2ɌWX^       */
	/*  ̒lĂ         */

#define PROC_INTERRUPT_SYS							\
	and     t2, a2, a1;          /*  ݗvrbgɃ}XN  */	\
	andi    t3, t2, Cause_IP0;   /*  IP0rbgo  */			\
	bne     t3, zero, proc_IP0;						\
	andi    t4, t2, Cause_IP1;   /*  IP1rbgo  */			\
	bne     t4, zero, proc_IP1;						\
	andi    t5, t2, Cause_IP2;   /*  IP2rbgo  */			\
	bne     t5, zero, proc_IP2;						\
	andi    t6, t2, Cause_IP3;   /*  IP3rbgo  */			\
	bne     t6, zero, proc_IP3;						\
	andi    t7, t2, Cause_IP4;   /*  IP4rbgo  */			\
	bne     t7, zero, proc_IP4;						\
	nop;									\
	/* VR4131̏ꍇACause_IP5Cause_IP6͖ڑȂ̂ŏȗ */		\
	/*in[hEFAp196QƁj*/						\
										\
	/* Ȃ炩̌ŕłȂꍇ */					\
	j       join_interrupt_and_exception;					\
	nop;									\
										\
										\
/*  MIPS3RAxŕ򂵂xł̏		*/			\
/*    ݗvԍ t0 ɓ			*/			\
/*    ݗvNÂ߂̒萔 t1 ɓ	*/			\
/*    set_ICU_IPM ֔				*/			\
proc_IP7:   /*  ݗvIP7i^C}j̏ꍇ  */				\
	xori    t1, zero, Cause_IP7;						\
	j       set_ICU_IPM;							\
	ori     t0, zero, INTNO_IP7;						\
										\
proc_IP0:   /*  ݗvIP0i\tgEFA0j̏ꍇ  */			\
	xori    t1, zero, Cause_IP0;						\
	j       set_ICU_IPM;							\
	ori     t0, zero, INTNO_IP0;						\
										\
proc_IP1:   /*  ݗvIP1i\tgEFA1j̏ꍇ  */			\
	xori    t1, zero, Cause_IP1;						\
	j       set_ICU_IPM;							\
	ori     t0, zero, INTNO_IP1;						\
										\
proc_IP2:   /*  ݗvIP2iInt0j̏ꍇ  */					\
            /*  uׂĂ̊݁vʒmB*/				\
	PROC_INT0;	/* 򏈗 vr4131_icu.h Ń}N`Ă */	\
	xori    t1, zero, Cause_IP2;						\
	j       set_ICU_IPM;							\
	nop;									\
										\
proc_IP3:   /*  ݗvIP3iInt1j̏ꍇ  */ 				\
            /*  urtc_long1_intrviC^[o^C}jʒmB*/	\
	xori    t1, zero, Cause_IP3;						\
	j       set_ICU_IPM;							\
	ori     t0, zero, INTNO_IP3;						\
										\
proc_IP4:   /*  ݗvIP4iInt2j̏ꍇ  */ 				\
            /*  urtc_long2_intrviC^[o^C}jʒmB*/	\
	xori    t1, zero, Cause_IP4;						\
	j       set_ICU_IPM;							\
	ori     t0, zero, INTNO_IP4;						\
										\
/*  ݃Rg[ˑ̃}XNݒ  */					\
set_ICU_IPM:									\
										\
	SET_ICU_IPM;	/* ݃}XNݒ肷}N			    */	\
			/*   sƂɂ́ALɂt0At1͗p */	\
			/*   Ŕj󂵂Ȃ悤ɁAӂȂ΂ȂȂB   */	\
										\
/*  WX^IPrbgɕێĂe튄݂̊ݗvNAB	\
    t1ɂ́Aݗvrbg𔽓]̂ĂB */			\
										\
	mfc0    t8, Cause;							\
	and     t8, t8, t1;							\
	mtc0    t8, Cause;							\
										\
/*  Xe[^XWX^̃}XNݒCꃋ[`Ăяo  */			\
/*    t0Ɋݗvԍݒ肳ꂽԂłɗ  */			\
	la      t3, int_table;   /* [xN^AhX */			\
	sll     t4, t0, 3;       /* ݗvԍ8{				\
				      INT_TABLE^́A				\
					nh̃AhX(4oCg)		\
					{MIPS3RÅ݃}XN(4oCg)	\
				      ́Av8oCgB */			\
	add     t5, t3, t4;      /* xN^AhXZo */			\
	lw      t6, INT_TABLE_intmask(t5);					\
           		    	/*  IPM(݋rbg)ǂݏoB		\
				    ݃}XNȊO̒ĺA			\
					IErbg̓Zbg			\
					EXLrbg̓Zbg			\
				    ԂɂȂĂB*/			\
	lw      t7, (t5);        /* Cꃋ[`擪AhXǂݏo  */	\
										\
	jalr    ra, t7;          /* Cꃋ[`Ăяo  */			\
	mtc0    t6, Status;      /* ݋GXe[^XWX^̃}XNݒ*/\
										\
	mfc0    t0, Status;							\
	ori     t0, t0, SR_EXL;  /* ݋֎~GIErbg̒l͕ێȂ΂Ȃ\
						Ȃ̂EXLrbgpB*/	\
	mtc0    t0, Status;							\
										\
	/*  CP0nU[ĥ߂̎ԉ҂  */					\
	NOP_FOR_CP0_HAZARD;

#endif /* _VR4131_ICU_H_ */
