/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _VR4131_H_
#define _VR4131_H_

/*
 *  VR4131 n[hEFA`
 */

/* CP0nU[ĥ߂̎ԉ҂ NOP_FOR_CP0_HAZARD  */
/* VR4131łmtc0߂̒ォ犄݋֎~ɂȂĂ̂nop߂}ȂĂ
   v */
#define NOP_FOR_CP0_HAZARD

/* ConfigWX^  */
#define BP		BIT16	/* \̐ݒ */

/* TLB ̃Gg̍ől  */
#define TMAX_TLB	31

/* TLB}XNl */
#define TLB_VPN2	0x800

/* LbV */
#define Index_Invalidate_I	(0x0+0x0)
#define Index_Store_Tag_I       (0x8+0x0)
#define Index_Store_Tag_D       (0x8+0x1)

/* LbṼCTCY(oCgP)  */
#define D_CACHE_LINE_SIZE 	0x10	/* 16oCg */
#define I_CACHE_LINE_SIZE 	0x10	/* 16oCg */

/*============================================================================*/

#ifndef _MACRO_ONLY

Inline void
vr4131_exit() {
	while(1);
	/* GDB_STUB gpɂ́ASTUB̓ɔԏKvB */
}

#endif /* _MACRO_ONLY */

/*============================================================================*/
/* ȉ̒`́AejbgƂɁAvr4131_xxx.hƂĂ܂Ƃ߂邱ƂKvB */

/*
 * NbN}XNjbg(CMU)֌W̒`
 */
#define CMUCLKMSK	0x0f000060

#define MSKSIU		BIT1	/* SIU, DSIUւTClock̐ */
#define MSKSSIU		BIT8	/* SIUւ18.432MHzNbN̐ */
#define MSKDSIU		BIT11	/* DSIUւ18.432MHzNbN̐ */

/*
 * p[}l[Wgjbg(PMU)֌W̒`
 */
#define PMUINTREG	0x0f0000c0	/* PMU ݁^Xe[^XWX^ */
#define PMUCNTREG	0x0f0000c2	/* PMU Rg[WX^ */
#define PMUTCLKDIVREG	0x0f0000cc

/* for PMUINTREG */
#define TIMOUTRST	BIT5		/* HALTimerZbgo */

/* for PMUCNTREG */
#define HALTIMERRST	BIT2		/* HALTimerZbg*/

/* for PMUTCLKDIVREG */
#define VTDIV_3		(BIT1 | BIT0)

/*
 * oXRg[jbg(BCU)֌W̒`
 */
#define BCUCNTREG1	0x0f000000
#define ROMSIZEREG	0x0f000004
#define ROMSPEEDREG	0x0f000006
#define IO0SPEEDREG	0x0f000008
#define IO1SPEEDREG	0x0f00000a
#define BCUCNTREG3	0x0f000016

/* for ROMSIZEREG */
#define SIZE3_4			BIT12
#define SIZE2_4			BIT8
#define SIZE1_4			BIT4
#define SIZE0_4			BIT0

/* for ROMSPEEDREG */
#define ROM4_WAIT_5VTClock	(BIT13 | BIT12)
#define ROM2_WAIT_8VTClock	(BIT2 | BIT0)

/* for IO0SPEEDREG */
#define IO0_1_WAIT_4		(BIT1 | BIT0)

/* for IO1SPEEDREG */
#define IO1_3_WAIT_11		BIT11

/* for BCUCNTREG3 */
#define EXT_ROMCS_3ROM_2ROM	(BIT13 | BIT12)
#define IO32			BIT7
#define LCDSEL1_BUFFER		BIT1
#define LCDSEL0_BUFFER		BIT0

/*
 * SDRAMRg[jbg(SDRAMU)֌W̒`
 */
#define SDRAMMODEREG	0x0f000400
#define SDRAMCNTREG	0x0f000402
#define BCURFCNTREG	0x0f000404
#define BCURFCOUNTREG	0x0f000406
#define RAMSIZEREG	0x0f000408

/* for SDRAMMODEREG */
#define SCLK		BIT15
#define LTMODE_2	BIT5

/* for SDRAMCNTREG */
#define TRC_3VTClock	(BIT9 | BIT8)
#define TDAL_2VTClock	BIT5
#define TRCD_2VTClock	BIT1

/* for RAMSIZEREG */
#define SIZE3_64	(BIT14 | BIT12)
#define SIZE2_64	(BIT10 | BIT8)
#define SIZE1_64	(BIT6 | BIT4)
#define SIZE0_64	(BIT2 | BIT0)

/*
 * VAC^tF[Xjbg(SIU)֌W̒`
 */
#define SIURESET	0x0f000809

/* for SIURESET */
#define DSIURESET	BIT1	/*  DSIUZbgtO  */

#endif /* _VR4131_H_ */
