/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#define _MACRO_ONLY

#include "jsp_kernel.h"

	.section ".exce_vec_map","xa"
		/* exce_vec_map ZNV̋Lq́A1kbyteɎ߂
		   ƁB(0xbfc00000-0xbfc00400 ͈͓̔)
		   ́A0xbfc00400 ̗̈ɁAinit ZNV
		   Ȃт text ZNVLq邽߁B*/

	.set noreorder

	.align 2

/*
 *  OxN^AhXł̕򏈗 (BEV=1z)
 */

/*
 *  R[hZbgA\tgZbgANMI(Non Maskable Interrupt)
 *     Xe[^XWX^BEVrbg
 *         ˑȂF0xbfc00000Ԓn  (kseg1̈GLbVȂ)
 */

	.global start	/* Gg[|Cg */

start:
reset_and_NMI:
	mfc0	k0, Status
	li	k1, SR_SR
	and	k1, k0, k1
	bne	k1, zero, NMI_exception
	nop

	/* R[hZbg */
	la	k1, reset
	jr	k1
	nop

	/* \tgZbgANMI  */
NMI_exception:
	la	k1, reset
	jr	k1
	nop

/*
 *  TLBsvOiJSPJ[lłTLBgpj
 *      Xe[^XWX^BEVrbg
 *          1̂ƂF0xbfc00200Ԓn  (kseg1̈GLbVȂ)
 *          0̂ƂF0x80000000Ԓn  (kseg0̈GLbV)
 */
	.org 0x200

TLB_miscompare_exception:
	move	a0, sp
	mfc0	a1, Status
	mfc0	a2, Cause
	la	k1, cpu_experr
	jr	k1
	nop

/*
 *  XTLBsvOiJSPJ[lłTLBgpj
 *      Xe[^XWX^BEVrbg
 *          1̂ƂF0xbfc00280Ԓn  (kseg1̈GLbVȂ)
 *          0̂ƂF0x80000080Ԓn  (kseg0̈GLbV)
 */
	.org 0x280

XTLB_miscompare_exception:
	move	a0, sp
	mfc0	a1, Status
	mfc0	a2, Cause
	la	k1, cpu_experr
	jr	k1
	nop

/*
 *  LbVG[O
 *      Xe[^XWX^BEVrbg
 *          1̂ƂF0xbfc00300Ԓn  (kseg1̈GLbVȂ)
 *          0̂ƂF0xa0000100Ԓn  (kseg0̈GLbV)
 */
	.org 0x300

cashe_error_exception:
	move	a0, sp
	mfc0	a1, Status
	mfc0	a2, Cause
	la	k1, cpu_experr
	jr	k1
	nop

/*
 *  ̑OFO/荞ݏo[`
 *  (MIPSA[LeN`͊݃xN^e[uA݂ʗO
 *   Ƃĕ򂷂)
 *      Xe[^XWX^BEVrbg
 *          1̂ƂF0xbfc00380Ԓn  (kseg1̈GLbVȂ)
 *          0̂ƂF0x80000180Ԓn  (kseg0̈GLbV)
 */

	.org 0x200 + 0x180	/* TLBsvO0x180Ԓnɔzu */

other_exception:
	la	k1, general_exception
	jr	k1
	nop
