/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

/*
 *  vZbTɈˑ`iMIPS3pj
 *
 *  ̃CN[ht@ĆCkernel.h  sil.h ŃCN[hD
 *  ̃t@C璼ڃCN[h邱Ƃ͂ȂD̃t@CC
 *  N[hOɁCt_stddef.h  itron.h CN[ĥŁC
 *  ɈˑĂ悢D
 */

#define MIPS3

/* J[lÑbZ[W */
#define COPYRIGHT_CPU \
"Copyright (C) 2001-2003 by Industrial Technology Institute,\n" \
"                            Miyagi Prefectural Government, JAPAN\n"

#ifndef _MACRO_ONLY

/*
 *  ݁^CPUOnhԍ̌^
 */
typedef	UINT	INHNO;			/* ݃nhԍ */
typedef	UINT	EXCNO;			/* CPUOnhԍ */

/*
 *  ݃}XŇ^Ɗ݃}XN̕ύX^Q
 */

/* MIPS3RÅ݃}XŇ^` (l̓VXeˑɋLq) */
typedef	UW	CORE_IPM;

/* ݃}XŇ^ */
typedef	struct {
	CORE_IPM	core;	/*  MIPS3RÅ݃}XN  */
	ICU_IPM		icu;	/*  ݃Rg[̊݃}XN  */
} IPM;

/* ݃}XNp̊֐ */
extern ER	chg_ipm(IPM p_ipm) throw();	/* ݃}XN̕ύX */
extern ER	get_ipm(IPM *p_ipm) throw();	/* ݃}XN̎擾 */

#endif /* _MACRO_ONLY */

/*
 *  ݃bNԂ̐
 *    MIPS3ł́ASĂ̊荞݂J[lǗȂ̂ŁA
 *      ݃bN = CPUbN
 *    ƂȂÃ}N̓éAWɒ񋟂Ă̂gB
 *    (Aʂɒ`悤ƂȂ΁AL̂悤ɂȂB)
 */
/*
#define	SIL_PRE_LOC
#define	SIL_LOC_INT()	t_lock_cpu()
#define	SIL_UNL_INT()	t_unlock_cpu()
*/
/*============================================================================*/
/*  ʃhLgɖ`  */

/*  Ŝ݂̖̊{  */
#define TMAX_ALL_INTNO	(TMAX_CORE_INTNO + TMAX_ICU_INTNO)

#ifndef _MACRO_ONLY

/*  ݃nh^݃}XN[e[up̌^  */
typedef struct {
	FP		inthdr;		/*  ݃nh̐擪AhX  */
	CORE_IPM	intmask;	/*  MIPS3RÅ݃}XN  */
} INT_TABLE;

#endif /* _MACRO_ONLY */

#endif /* _CPU_DEFS_H_ */
